/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fallbacks;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.Fallback;
import org.jclouds.fallbacks.PropagateIfRetryAfter;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public final class MapHttp4xxCodesToExceptions
implements Fallback<Object> {
    private final PropagateIfRetryAfter propagateIfRetryAfter;

    @Inject
    MapHttp4xxCodesToExceptions(PropagateIfRetryAfter propagateIfRetryAfter) {
        this.propagateIfRetryAfter = Preconditions.checkNotNull(propagateIfRetryAfter, "propagateIfRetryAfter");
    }

    @Override
    public ListenableFuture<Object> create(Throwable t) throws Exception {
        return Futures.immediateFuture(this.createOrPropagate(t));
    }

    @Override
    public Object createOrPropagate(Throwable t) throws Exception {
        HttpResponseException responseException;
        this.propagateIfRetryAfter.create(t);
        if (t instanceof HttpResponseException && (responseException = (HttpResponseException)HttpResponseException.class.cast(t)).getResponse() != null) {
            switch (responseException.getResponse().getStatusCode()) {
                case 401: {
                    throw new AuthorizationException(responseException);
                }
                case 403: {
                    throw new AuthorizationException(responseException);
                }
                case 404: {
                    throw new ResourceNotFoundException(responseException);
                }
                case 409: {
                    throw new IllegalStateException(responseException);
                }
            }
        }
        throw Throwables.propagate(t);
    }
}

