/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindIterableToHeadersWithContainerDeleteMetadataPrefix
implements Binder {
    private final Function<String, String> FN = new Function<String, String>(){

        @Override
        public String apply(String element) {
            String inLowercase = element.toLowerCase();
            return inLowercase.startsWith("X-Remove-Container-Meta-") ? inLowercase : "X-Remove-Container-Meta-" + inLowercase;
        }

        public String toString() {
            return "prefix: X-Remove-Container-Meta-";
        }
    };

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Iterable, "this binder is only valid for Iterable!");
        Preconditions.checkNotNull(request, "request");
        Iterable<String> metadataKeys = Iterables.transform((Iterable)input, this.FN);
        HashMultimap<String, String> headers = HashMultimap.create();
        for (String metadataKey : metadataKeys) {
            headers.put((Object)metadataKey, (Object)"");
        }
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders(headers)).build();
    }
}

