/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class CrudMethodMetadataPostProcessor
implements RepositoryProxyPostProcessor,
BeanClassLoaderAware {
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    CrudMethodMetadataPostProcessor() {
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? ClassUtils.getDefaultClassLoader() : classLoader;
    }

    @Override
    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice(CrudMethodMetadataPopulatingMethodInterceptor.INSTANCE);
    }

    public CrudMethodMetadata getCrudMethodMetadata() {
        ProxyFactory factory = new ProxyFactory();
        factory.addInterface(CrudMethodMetadata.class);
        factory.setTargetSource(new ThreadBoundTargetSource());
        return (CrudMethodMetadata)factory.getProxy(this.classLoader);
    }

    private static class ThreadBoundTargetSource
    implements TargetSource {
        private ThreadBoundTargetSource() {
        }

        @Override
        public Class<?> getTargetClass() {
            return CrudMethodMetadata.class;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Object getTarget() throws Exception {
            MethodInvocation invocation = ExposeInvocationInterceptor.currentInvocation();
            return TransactionSynchronizationManager.getResource(invocation.getMethod());
        }

        @Override
        public void releaseTarget(Object target) throws Exception {
        }
    }

    private static class DefaultCrudMethodMetadata
    implements CrudMethodMetadata {
        private final LockModeType lockModeType;
        private final Map<String, Object> queryHints;
        private final EntityGraph entityGraph;
        private final Method method;

        public DefaultCrudMethodMetadata(Method method) {
            Assert.notNull(method, "Method must not be null!");
            this.lockModeType = DefaultCrudMethodMetadata.findLockModeType(method);
            this.queryHints = DefaultCrudMethodMetadata.findQueryHints(method);
            this.entityGraph = DefaultCrudMethodMetadata.findEntityGraph(method);
            this.method = method;
        }

        private static EntityGraph findEntityGraph(Method method) {
            return AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EntityGraph.class);
        }

        private static LockModeType findLockModeType(Method method) {
            Lock annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Lock.class);
            return annotation == null ? null : (LockModeType)((Object)AnnotationUtils.getValue(annotation));
        }

        private static Map<String, Object> findQueryHints(Method method) {
            QueryHint queryHintAnnotation;
            HashMap<String, String> queryHints = new HashMap<String, String>();
            QueryHints queryHintsAnnotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, QueryHints.class);
            if (queryHintsAnnotation != null) {
                for (QueryHint hint : queryHintsAnnotation.value()) {
                    queryHints.put(hint.name(), hint.value());
                }
            }
            if ((queryHintAnnotation = AnnotationUtils.findAnnotation(method, QueryHint.class)) != null) {
                queryHints.put(queryHintAnnotation.name(), queryHintAnnotation.value());
            }
            return Collections.unmodifiableMap(queryHints);
        }

        @Override
        public LockModeType getLockModeType() {
            return this.lockModeType;
        }

        @Override
        public Map<String, Object> getQueryHints() {
            return this.queryHints;
        }

        @Override
        public EntityGraph getEntityGraph() {
            return this.entityGraph;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }
    }

    static enum CrudMethodMetadataPopulatingMethodInterceptor implements MethodInterceptor
    {
        INSTANCE;

        private final ConcurrentMap<Method, CrudMethodMetadata> metadataCache = new ConcurrentHashMap<Method, CrudMethodMetadata>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            CrudMethodMetadata tmp;
            Method method = invocation.getMethod();
            CrudMethodMetadata metadata = (CrudMethodMetadata)TransactionSynchronizationManager.getResource(method);
            if (metadata != null) {
                return invocation.proceed();
            }
            CrudMethodMetadata methodMetadata = (CrudMethodMetadata)this.metadataCache.get(method);
            if (methodMetadata == null && (tmp = this.metadataCache.putIfAbsent(method, methodMetadata = new DefaultCrudMethodMetadata(method))) != null) {
                methodMetadata = tmp;
            }
            TransactionSynchronizationManager.bindResource(method, methodMetadata);
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                TransactionSynchronizationManager.unbindResource(method);
            }
        }
    }
}

