/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp.dup;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.common.storageprovider.StorageProviderFactory;
import org.duracloud.mill.credentials.AccountCredentials;
import org.duracloud.mill.credentials.AccountCredentialsNotFoundException;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.StorageProviderCredentials;
import org.duracloud.mill.dup.DuplicationPolicy;
import org.duracloud.mill.dup.DuplicationPolicyManager;
import org.duracloud.mill.dup.DuplicationStorePolicy;
import org.duracloud.mill.ltp.Frequency;
import org.duracloud.mill.ltp.LoopingTaskProducer;
import org.duracloud.mill.ltp.LoopingTaskProducerConfigurationManager;
import org.duracloud.mill.ltp.Morsel;
import org.duracloud.mill.ltp.MorselComparator;
import org.duracloud.mill.ltp.RunStats;
import org.duracloud.mill.ltp.StateManager;
import org.duracloud.mill.ltp.dup.DuplicationMorsel;
import org.duracloud.mill.ltp.dup.DuplicationRunStats;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.mill.task.DuplicationTask;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingDuplicationTaskProducer
extends LoopingTaskProducer<DuplicationMorsel> {
    private static Logger log = LoggerFactory.getLogger(LoopingDuplicationTaskProducer.class);
    private DuplicationPolicyManager policyManager;
    private Cache cache;

    public LoopingDuplicationTaskProducer(CredentialsRepo credentialsRepo, StorageProviderFactory storageProviderFactory, DuplicationPolicyManager policyManager, TaskQueue taskQueue, Cache cache, StateManager<DuplicationMorsel> state, int maxTaskQueueSize, Frequency frequency, NotificationManager notificationManager, LoopingTaskProducerConfigurationManager config) {
        super(credentialsRepo, storageProviderFactory, taskQueue, state, maxTaskQueueSize, frequency, null, notificationManager, config);
        this.cache = cache;
        this.policyManager = policyManager;
    }

    private Cache getCache() {
        return this.cache;
    }

    @Override
    protected void loadMorselQueueFromSource(Queue<DuplicationMorsel> morselQueue) {
        for (String account : this.policyManager.getDuplicationAccounts()) {
            DuplicationPolicy policy = this.policyManager.getDuplicationPolicy(account);
            try {
                CredentialsRepo credRepo = this.getCredentialsRepo();
                if (!this.getCredentialsRepo().isAccountActive(account)) continue;
                AccountCredentials accountCreds = credRepo.getAccountCredentials(account);
                for (StorageProviderCredentials cred : accountCreds.getProviderCredentials()) {
                    if (!cred.isPrimary()) continue;
                    StorageProvider provider = this.getStorageProvider(cred);
                    Iterator<String> spaces = provider.getSpaces();
                    while (spaces.hasNext()) {
                        String spaceId = spaces.next();
                        Set<DuplicationStorePolicy> storePolicies = policy.getDuplicationStorePolicies(spaceId);
                        for (DuplicationStorePolicy storePolicy : storePolicies) {
                            morselQueue.add(new DuplicationMorsel(account, spaceId, null, storePolicy));
                        }
                    }
                }
            }
            catch (AccountCredentialsNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void nibble(Queue<DuplicationMorsel> queue) {
        DuplicationMorsel morsel = queue.poll();
        String account = morsel.getAccount();
        String spaceId = morsel.getSpaceId();
        DuplicationStorePolicy storePolicy = morsel.getStorePolicy();
        StorageProvider sourceProvider = this.getStorageProvider(account, storePolicy.getSrcStoreId());
        StorageProvider destProvider = this.getStorageProvider(account, storePolicy.getDestStoreId());
        if (!morsel.isDeletePerformed()) {
            this.addDuplicationTasksForContentNotInSource(account, spaceId, storePolicy, sourceProvider, destProvider);
            morsel.setDeletePerformed(true);
        }
        int maxTaskQueueSize = this.getMaxTaskQueueSize();
        int taskQueueSize = this.getTaskQueue().size();
        if (taskQueueSize >= maxTaskQueueSize) {
            log.info("Task queue size ({}) has reached or exceeded max size ({}).", (Object)taskQueueSize, (Object)maxTaskQueueSize);
            this.addToReloadList(morsel);
        } else if (this.addDuplicationTasksFromSource(morsel, sourceProvider, 1000)) {
            log.info("All tasks that could be created were created for account={}, spaceId={}, storePolicy={}. getTaskQueue().size = {}", account, spaceId, storePolicy, this.getTaskQueue().size());
            log.info("morsel completely nibbled. No reload necessary in this round.", (Object)morsel);
        } else {
            log.info("morsel nibbled a bit: {}", (Object)morsel);
            this.addToReloadList(morsel);
        }
    }

    @Override
    protected StorageProvider getStorageProvider(String account, String storeId) {
        return super.getStorageProvider(account, storeId);
    }

    private boolean addDuplicationTasksFromSource(DuplicationMorsel morsel, StorageProvider sourceProvider, int maxContentIdsToAdd) {
        String account = morsel.getAccount();
        String spaceId = morsel.getSpaceId();
        String marker = morsel.getMarker();
        DuplicationStorePolicy storePolicy = morsel.getStorePolicy();
        List<String> contentIds = null;
        try {
            contentIds = sourceProvider.getSpaceContentsChunked(spaceId, null, maxContentIdsToAdd, marker);
        }
        catch (NotFoundException ex) {
            log.info("space not found on source provider: account={}, spaceId={}, storeId={}", account, spaceId, sourceProvider);
            this.addDeleteSpaceTaskToQueue(account, spaceId, storePolicy, sourceProvider);
            return true;
        }
        int contentIdCount = contentIds.size();
        if (contentIdCount == 0) {
            return true;
        }
        int added = this.addToTaskQueue(account, spaceId, storePolicy, contentIds);
        ((DuplicationRunStats)this.getStats(account)).addToDups(added);
        if (added == 0) {
            return true;
        }
        marker = contentIds.get(contentIds.size() - 1);
        morsel.setMarker(marker);
        return false;
    }

    private void addDuplicationTasksForContentNotInSource(String account, String spaceId, DuplicationStorePolicy storePolicy, StorageProvider sourceProvider, StorageProvider destProvider) {
        Cache cache = this.getCache();
        try {
            Iterator<String> sourceContentIds = sourceProvider.getSpaceContents(spaceId, null);
            while (sourceContentIds.hasNext()) {
                cache.put(new Element((Serializable)((Object)sourceContentIds.next()), null));
            }
        }
        catch (NotFoundException ex) {
            log.info("space not found on source provider: account={}, spaceId={}, storeId={}", account, spaceId, sourceProvider);
        }
        Iterator<String> destContentIds = null;
        try {
            destContentIds = destProvider.getSpaceContents(spaceId, null);
        }
        catch (NotFoundException ex) {
            log.info("space not found on destination provider: account={}, spaceId={}, storeId={}", account, spaceId, destProvider);
            return;
        }
        int deletionTaskCount = 0;
        LinkedList<String> deletions = new LinkedList<String>();
        while (destContentIds.hasNext()) {
            String destContentId = destContentIds.next();
            if (cache.isKeyInCache(destContentId)) continue;
            deletions.add(destContentId);
            if (deletions.size() != 10000) continue;
            deletionTaskCount += this.addToTaskQueue(account, spaceId, storePolicy, deletions);
            deletions.clear();
        }
        ((DuplicationRunStats)this.getStats(account)).addToDeletes(deletionTaskCount += this.addToTaskQueue(account, spaceId, storePolicy, deletions));
        log.info("added {} deletion tasks: account={}, spaceId={}, sourceStoreId={}, destStoreId={}", deletionTaskCount, account, spaceId, storePolicy.getSrcStoreId(), storePolicy.getDestStoreId());
        cache.removeAll();
    }

    private void addDeleteSpaceTaskToQueue(String account, String spaceId, DuplicationStorePolicy storePolicy, StorageProvider sourceProvider) {
        DuplicationTask task = new DuplicationTask();
        task.setAccount(account);
        task.setSourceStoreId(storePolicy.getSrcStoreId());
        task.setContentId("");
        task.setDestStoreId(storePolicy.getDestStoreId());
        task.setSpaceId(spaceId);
        this.getTaskQueue().put(task.writeTask());
        log.info("destintation space delete task added to queue since source does not exist: account={}, spaceId={}, storeId={}", account, spaceId, sourceProvider);
    }

    private int addToTaskQueue(String account, String spaceId, DuplicationStorePolicy storePolicy, List<String> contentIds) {
        HashSet<Task> tasks = new HashSet<Task>();
        int addedCount = 0;
        for (String contentId : contentIds) {
            DuplicationTask dupTask = new DuplicationTask();
            dupTask.setAccount(account);
            dupTask.setContentId(contentId);
            dupTask.setSpaceId(spaceId);
            dupTask.setStoreId(storePolicy.getSrcStoreId());
            dupTask.setSourceStoreId(storePolicy.getSrcStoreId());
            dupTask.setDestStoreId(storePolicy.getDestStoreId());
            Task task = dupTask.writeTask();
            tasks.add(task);
            ++addedCount;
        }
        this.getTaskQueue().put(tasks);
        return addedCount;
    }

    @Override
    protected void logIncrementalStatsByAccount(String account, RunStats stats) {
        DuplicationRunStats dstats = (DuplicationRunStats)stats;
        log.info("Session stats by account (incremental): account={} dups={} deletes={}", account, dstats.getDups(), dstats.getDeletes());
    }

    @Override
    protected void logCumulativeSessionStats(Map<String, RunStats> runstats, RunStats cumulativeTotals) {
        DuplicationRunStats dCumulativeTotals = (DuplicationRunStats)cumulativeTotals;
        log.info("session stats (global cumulative): domains={} dups={}  deletes={}", runstats.keySet().size(), dCumulativeTotals.getDups(), dCumulativeTotals.getDeletes());
    }

    @Override
    protected void logGlobalncrementalStats(RunStats incrementalTotals) {
        DuplicationRunStats dIncrementalTotals = (DuplicationRunStats)incrementalTotals;
        log.info("Session stats (global incremental): dups={} deletes={}", (Object)dIncrementalTotals.getDups(), (Object)dIncrementalTotals.getDeletes());
    }

    @Override
    protected RunStats createRunStats() {
        return new DuplicationRunStats();
    }

    @Override
    protected Queue<DuplicationMorsel> createQueue() {
        return new PriorityBlockingQueue<Morsel>(1000, new MorselComparator());
    }

    @Override
    protected String getLoopingProducerTypePrefix() {
        return "dup";
    }
}

