/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3storage;

import org.apache.commons.lang3.RandomStringUtils;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.util.IOUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.domain.RetrievedContent;
import org.duracloud.storage.error.NotFoundException;

public class StringDataStore {
    private S3StorageProvider s3StorageProvider;
    private String hiddenSpaceName;

    public StringDataStore(String hiddenSpaceName, S3StorageProvider s3StorageProvider) {
        this.s3StorageProvider = s3StorageProvider;
        this.hiddenSpaceName = hiddenSpaceName;
    }

    public String storeData(String cookieData) {
        try {
            String token = this.generateToken();
            this.ensureSpaceExists();
            this.s3StorageProvider.addHiddenContent(this.hiddenSpaceName, token, "application/json", IOUtil.writeStringToStream(cookieData));
            return token;
        }
        catch (Exception e) {
            throw new DuraCloudRuntimeException(e);
        }
    }

    private void ensureSpaceExists() {
        if (!this.s3StorageProvider.spaceExists(this.hiddenSpaceName)) {
            this.s3StorageProvider.createHiddenSpace(this.hiddenSpaceName, 1);
        }
    }

    public String retrieveData(String token) {
        try {
            RetrievedContent data = this.s3StorageProvider.getContent(this.hiddenSpaceName, token);
            return IOUtil.readStringFromStream(data.getContentStream());
        }
        catch (NotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new DuraCloudRuntimeException(ex);
        }
    }

    private String generateToken() {
        return RandomStringUtils.randomAlphanumeric(20);
    }
}

