/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginShield;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class OriginShieldStaxUnmarshaller
implements Unmarshaller<OriginShield, StaxUnmarshallerContext> {
    private static OriginShieldStaxUnmarshaller instance;

    @Override
    public OriginShield unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginShield originShield = new OriginShield();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originShield;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    originShield.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginShieldRegion", targetDepth)) continue;
                originShield.setOriginShieldRegion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originShield;
    }

    public static OriginShieldStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginShieldStaxUnmarshaller();
        }
        return instance;
    }
}

