/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.Aliases;
import com.amazonaws.services.cloudfront.model.AllowedMethods;
import com.amazonaws.services.cloudfront.model.CacheBehavior;
import com.amazonaws.services.cloudfront.model.CacheBehaviors;
import com.amazonaws.services.cloudfront.model.CachedMethods;
import com.amazonaws.services.cloudfront.model.CookieNames;
import com.amazonaws.services.cloudfront.model.CookiePreference;
import com.amazonaws.services.cloudfront.model.CustomErrorResponse;
import com.amazonaws.services.cloudfront.model.CustomErrorResponses;
import com.amazonaws.services.cloudfront.model.CustomHeaders;
import com.amazonaws.services.cloudfront.model.CustomOriginConfig;
import com.amazonaws.services.cloudfront.model.DefaultCacheBehavior;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.FunctionAssociation;
import com.amazonaws.services.cloudfront.model.FunctionAssociations;
import com.amazonaws.services.cloudfront.model.GeoRestriction;
import com.amazonaws.services.cloudfront.model.Headers;
import com.amazonaws.services.cloudfront.model.LambdaFunctionAssociation;
import com.amazonaws.services.cloudfront.model.LambdaFunctionAssociations;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.OriginCustomHeader;
import com.amazonaws.services.cloudfront.model.OriginGroup;
import com.amazonaws.services.cloudfront.model.OriginGroupFailoverCriteria;
import com.amazonaws.services.cloudfront.model.OriginGroupMember;
import com.amazonaws.services.cloudfront.model.OriginGroupMembers;
import com.amazonaws.services.cloudfront.model.OriginGroups;
import com.amazonaws.services.cloudfront.model.OriginShield;
import com.amazonaws.services.cloudfront.model.OriginSslProtocols;
import com.amazonaws.services.cloudfront.model.Origins;
import com.amazonaws.services.cloudfront.model.QueryStringCacheKeys;
import com.amazonaws.services.cloudfront.model.Restrictions;
import com.amazonaws.services.cloudfront.model.S3OriginConfig;
import com.amazonaws.services.cloudfront.model.StatusCodes;
import com.amazonaws.services.cloudfront.model.TrustedKeyGroups;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.services.cloudfront.model.ViewerCertificate;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class UpdateDistributionRequestMarshaller
implements Marshaller<Request<UpdateDistributionRequest>, UpdateDistributionRequest> {
    @Override
    public Request<UpdateDistributionRequest> marshall(UpdateDistributionRequest updateDistributionRequest) {
        if (updateDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDistributionRequest> request = new DefaultRequest<UpdateDistributionRequest>(updateDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(updateDistributionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/distribution/{Id}/config";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", updateDistributionRequest.getId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            DistributionConfig distributionConfig = updateDistributionRequest.getDistributionConfig();
            if (distributionConfig != null) {
                Restrictions restrictions;
                ViewerCertificate viewerCertificate;
                LoggingConfig logging;
                CustomErrorResponses customErrorResponses;
                CacheBehaviors cacheBehaviors;
                DefaultCacheBehavior defaultCacheBehavior;
                Iterator originGroupMembersItemsList;
                OriginGroups originGroups;
                Iterator customHeadersItemsListValue2;
                Origins origins;
                Aliases aliases;
                xmlWriter.startElement("DistributionConfig");
                if (distributionConfig.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(distributionConfig.getCallerReference()).endElement();
                }
                if ((aliases = distributionConfig.getAliases()) != null) {
                    SdkInternalList aliasesItemsList;
                    xmlWriter.startElement("Aliases");
                    if (aliases.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(aliases.getQuantity()).endElement();
                    }
                    if (!(aliasesItemsList = (SdkInternalList)aliases.getItems()).isEmpty() || !aliasesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (String aliasesItemsListValue : aliasesItemsList) {
                            xmlWriter.startElement("CNAME");
                            xmlWriter.value(aliasesItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getDefaultRootObject() != null) {
                    xmlWriter.startElement("DefaultRootObject").value(distributionConfig.getDefaultRootObject()).endElement();
                }
                if ((origins = distributionConfig.getOrigins()) != null) {
                    SdkInternalList originsItemsList;
                    xmlWriter.startElement("Origins");
                    if (origins.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(origins.getQuantity()).endElement();
                    }
                    if (!(originsItemsList = (SdkInternalList)origins.getItems()).isEmpty() || !originsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Origin originsItemsListValue : originsItemsList) {
                            OriginShield originShield;
                            CustomOriginConfig customOriginConfig;
                            S3OriginConfig s3OriginConfig;
                            CustomHeaders customHeaders;
                            xmlWriter.startElement("Origin");
                            if (originsItemsListValue.getId() != null) {
                                xmlWriter.startElement("Id").value(originsItemsListValue.getId()).endElement();
                            }
                            if (originsItemsListValue.getDomainName() != null) {
                                xmlWriter.startElement("DomainName").value(originsItemsListValue.getDomainName()).endElement();
                            }
                            if (originsItemsListValue.getOriginPath() != null) {
                                xmlWriter.startElement("OriginPath").value(originsItemsListValue.getOriginPath()).endElement();
                            }
                            if ((customHeaders = originsItemsListValue.getCustomHeaders()) != null) {
                                SdkInternalList customHeadersItemsList;
                                xmlWriter.startElement("CustomHeaders");
                                if (customHeaders.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(customHeaders.getQuantity()).endElement();
                                }
                                if (!(customHeadersItemsList = (SdkInternalList)customHeaders.getItems()).isEmpty() || !customHeadersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (Iterator customHeadersItemsListValue2 : customHeadersItemsList) {
                                        xmlWriter.startElement("OriginCustomHeader");
                                        if (((OriginCustomHeader)((Object)customHeadersItemsListValue2)).getHeaderName() != null) {
                                            xmlWriter.startElement("HeaderName").value(((OriginCustomHeader)((Object)customHeadersItemsListValue2)).getHeaderName()).endElement();
                                        }
                                        if (((OriginCustomHeader)((Object)customHeadersItemsListValue2)).getHeaderValue() != null) {
                                            xmlWriter.startElement("HeaderValue").value(((OriginCustomHeader)((Object)customHeadersItemsListValue2)).getHeaderValue()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((s3OriginConfig = originsItemsListValue.getS3OriginConfig()) != null) {
                                xmlWriter.startElement("S3OriginConfig");
                                if (s3OriginConfig.getOriginAccessIdentity() != null) {
                                    xmlWriter.startElement("OriginAccessIdentity").value(s3OriginConfig.getOriginAccessIdentity()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((customOriginConfig = originsItemsListValue.getCustomOriginConfig()) != null) {
                                OriginSslProtocols originSslProtocols;
                                xmlWriter.startElement("CustomOriginConfig");
                                if (customOriginConfig.getHTTPPort() != null) {
                                    xmlWriter.startElement("HTTPPort").value(customOriginConfig.getHTTPPort()).endElement();
                                }
                                if (customOriginConfig.getHTTPSPort() != null) {
                                    xmlWriter.startElement("HTTPSPort").value(customOriginConfig.getHTTPSPort()).endElement();
                                }
                                if (customOriginConfig.getOriginProtocolPolicy() != null) {
                                    xmlWriter.startElement("OriginProtocolPolicy").value(customOriginConfig.getOriginProtocolPolicy()).endElement();
                                }
                                if ((originSslProtocols = customOriginConfig.getOriginSslProtocols()) != null) {
                                    SdkInternalList originSslProtocolsItemsList;
                                    xmlWriter.startElement("OriginSslProtocols");
                                    if (originSslProtocols.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(originSslProtocols.getQuantity()).endElement();
                                    }
                                    if (!(originSslProtocolsItemsList = (SdkInternalList)originSslProtocols.getItems()).isEmpty() || !originSslProtocolsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        customHeadersItemsListValue2 = originSslProtocolsItemsList.iterator();
                                        while (customHeadersItemsListValue2.hasNext()) {
                                            String originSslProtocolsItemsListValue = (String)customHeadersItemsListValue2.next();
                                            xmlWriter.startElement("SslProtocol");
                                            xmlWriter.value(originSslProtocolsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if (customOriginConfig.getOriginReadTimeout() != null) {
                                    xmlWriter.startElement("OriginReadTimeout").value(customOriginConfig.getOriginReadTimeout()).endElement();
                                }
                                if (customOriginConfig.getOriginKeepaliveTimeout() != null) {
                                    xmlWriter.startElement("OriginKeepaliveTimeout").value(customOriginConfig.getOriginKeepaliveTimeout()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (originsItemsListValue.getConnectionAttempts() != null) {
                                xmlWriter.startElement("ConnectionAttempts").value(originsItemsListValue.getConnectionAttempts()).endElement();
                            }
                            if (originsItemsListValue.getConnectionTimeout() != null) {
                                xmlWriter.startElement("ConnectionTimeout").value(originsItemsListValue.getConnectionTimeout()).endElement();
                            }
                            if ((originShield = originsItemsListValue.getOriginShield()) != null) {
                                xmlWriter.startElement("OriginShield");
                                if (originShield.getEnabled() != null) {
                                    xmlWriter.startElement("Enabled").value(originShield.getEnabled()).endElement();
                                }
                                if (originShield.getOriginShieldRegion() != null) {
                                    xmlWriter.startElement("OriginShieldRegion").value(originShield.getOriginShieldRegion()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((originGroups = distributionConfig.getOriginGroups()) != null) {
                    SdkInternalList originGroupsItemsList;
                    xmlWriter.startElement("OriginGroups");
                    if (originGroups.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(originGroups.getQuantity()).endElement();
                    }
                    if (!(originGroupsItemsList = (SdkInternalList)originGroups.getItems()).isEmpty() || !originGroupsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Iterator originGroupsItemsListValue : originGroupsItemsList) {
                            OriginGroupMembers members;
                            Object statusCodesItemsList;
                            OriginGroupFailoverCriteria failoverCriteria;
                            xmlWriter.startElement("OriginGroup");
                            if (((OriginGroup)((Object)originGroupsItemsListValue)).getId() != null) {
                                xmlWriter.startElement("Id").value(((OriginGroup)((Object)originGroupsItemsListValue)).getId()).endElement();
                            }
                            if ((failoverCriteria = ((OriginGroup)((Object)originGroupsItemsListValue)).getFailoverCriteria()) != null) {
                                xmlWriter.startElement("FailoverCriteria");
                                StatusCodes statusCodes = failoverCriteria.getStatusCodes();
                                if (statusCodes != null) {
                                    xmlWriter.startElement("StatusCodes");
                                    if (statusCodes.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(statusCodes.getQuantity()).endElement();
                                    }
                                    if (!((ArrayList)(statusCodesItemsList = (SdkInternalList)statusCodes.getItems())).isEmpty() || !((SdkInternalList)statusCodesItemsList).isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        customHeadersItemsListValue2 = ((ArrayList)statusCodesItemsList).iterator();
                                        while (customHeadersItemsListValue2.hasNext()) {
                                            Iterator statusCodesItemsListValue = (Integer)customHeadersItemsListValue2.next();
                                            xmlWriter.startElement("StatusCode");
                                            xmlWriter.value(statusCodesItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((members = ((OriginGroup)((Object)originGroupsItemsListValue)).getMembers()) != null) {
                                xmlWriter.startElement("Members");
                                if (members.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(members.getQuantity()).endElement();
                                }
                                if (!((ArrayList)((Object)(originGroupMembersItemsList = (SdkInternalList)members.getItems()))).isEmpty() || !((SdkInternalList)((Object)originGroupMembersItemsList)).isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    statusCodesItemsList = ((ArrayList)((Object)originGroupMembersItemsList)).iterator();
                                    while (statusCodesItemsList.hasNext()) {
                                        OriginGroupMember originGroupMembersItemsListValue = (OriginGroupMember)statusCodesItemsList.next();
                                        xmlWriter.startElement("OriginGroupMember");
                                        if (originGroupMembersItemsListValue.getOriginId() != null) {
                                            xmlWriter.startElement("OriginId").value(originGroupMembersItemsListValue.getOriginId()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((defaultCacheBehavior = distributionConfig.getDefaultCacheBehavior()) != null) {
                    ForwardedValues forwardedValues;
                    FunctionAssociations functionAssociations;
                    LambdaFunctionAssociations lambdaFunctionAssociations;
                    AllowedMethods allowedMethods;
                    TrustedKeyGroups trustedKeyGroups;
                    TrustedSigners trustedSigners;
                    xmlWriter.startElement("DefaultCacheBehavior");
                    if (defaultCacheBehavior.getTargetOriginId() != null) {
                        xmlWriter.startElement("TargetOriginId").value(defaultCacheBehavior.getTargetOriginId()).endElement();
                    }
                    if ((trustedSigners = defaultCacheBehavior.getTrustedSigners()) != null) {
                        SdkInternalList trustedSignersItemsList;
                        xmlWriter.startElement("TrustedSigners");
                        if (trustedSigners.getEnabled() != null) {
                            xmlWriter.startElement("Enabled").value(trustedSigners.getEnabled()).endElement();
                        }
                        if (trustedSigners.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(trustedSigners.getQuantity()).endElement();
                        }
                        if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.getItems()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                                xmlWriter.startElement("AwsAccountNumber");
                                xmlWriter.value(trustedSignersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((trustedKeyGroups = defaultCacheBehavior.getTrustedKeyGroups()) != null) {
                        SdkInternalList trustedKeyGroupsItemsList;
                        xmlWriter.startElement("TrustedKeyGroups");
                        if (trustedKeyGroups.getEnabled() != null) {
                            xmlWriter.startElement("Enabled").value(trustedKeyGroups.getEnabled()).endElement();
                        }
                        if (trustedKeyGroups.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(trustedKeyGroups.getQuantity()).endElement();
                        }
                        if (!(trustedKeyGroupsItemsList = (SdkInternalList)trustedKeyGroups.getItems()).isEmpty() || !trustedKeyGroupsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String trustedKeyGroupsItemsListValue : trustedKeyGroupsItemsList) {
                                xmlWriter.startElement("KeyGroup");
                                xmlWriter.value(trustedKeyGroupsItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getViewerProtocolPolicy() != null) {
                        xmlWriter.startElement("ViewerProtocolPolicy").value(defaultCacheBehavior.getViewerProtocolPolicy()).endElement();
                    }
                    if ((allowedMethods = defaultCacheBehavior.getAllowedMethods()) != null) {
                        Iterator cachedMethods;
                        SdkInternalList allowedMethodsItemsList;
                        xmlWriter.startElement("AllowedMethods");
                        if (allowedMethods.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(allowedMethods.getQuantity()).endElement();
                        }
                        if (!(allowedMethodsItemsList = (SdkInternalList)allowedMethods.getItems()).isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                xmlWriter.startElement("Method");
                                xmlWriter.value(allowedMethodsItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((cachedMethods = allowedMethods.getCachedMethods()) != null) {
                            SdkInternalList cachedMethodsItemsList;
                            xmlWriter.startElement("CachedMethods");
                            if (((CachedMethods)((Object)cachedMethods)).getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value(((CachedMethods)((Object)cachedMethods)).getQuantity()).endElement();
                            }
                            if (!(cachedMethodsItemsList = (SdkInternalList)((CachedMethods)((Object)cachedMethods)).getItems()).isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (String cachedMethodsItemsListValue : cachedMethodsItemsList) {
                                    xmlWriter.startElement("Method");
                                    xmlWriter.value(cachedMethodsItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getSmoothStreaming() != null) {
                        xmlWriter.startElement("SmoothStreaming").value(defaultCacheBehavior.getSmoothStreaming()).endElement();
                    }
                    if (defaultCacheBehavior.getCompress() != null) {
                        xmlWriter.startElement("Compress").value(defaultCacheBehavior.getCompress()).endElement();
                    }
                    if ((lambdaFunctionAssociations = defaultCacheBehavior.getLambdaFunctionAssociations()) != null) {
                        SdkInternalList lambdaFunctionAssociationsItemsList;
                        xmlWriter.startElement("LambdaFunctionAssociations");
                        if (lambdaFunctionAssociations.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(lambdaFunctionAssociations.getQuantity()).endElement();
                        }
                        if (!(lambdaFunctionAssociationsItemsList = (SdkInternalList)lambdaFunctionAssociations.getItems()).isEmpty() || !lambdaFunctionAssociationsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue : lambdaFunctionAssociationsItemsList) {
                                xmlWriter.startElement("LambdaFunctionAssociation");
                                if (lambdaFunctionAssociationsItemsListValue.getLambdaFunctionARN() != null) {
                                    xmlWriter.startElement("LambdaFunctionARN").value(lambdaFunctionAssociationsItemsListValue.getLambdaFunctionARN()).endElement();
                                }
                                if (lambdaFunctionAssociationsItemsListValue.getEventType() != null) {
                                    xmlWriter.startElement("EventType").value(lambdaFunctionAssociationsItemsListValue.getEventType()).endElement();
                                }
                                if (lambdaFunctionAssociationsItemsListValue.getIncludeBody() != null) {
                                    xmlWriter.startElement("IncludeBody").value(lambdaFunctionAssociationsItemsListValue.getIncludeBody()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((functionAssociations = defaultCacheBehavior.getFunctionAssociations()) != null) {
                        SdkInternalList functionAssociationsItemsList;
                        xmlWriter.startElement("FunctionAssociations");
                        if (functionAssociations.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(functionAssociations.getQuantity()).endElement();
                        }
                        if (!(functionAssociationsItemsList = (SdkInternalList)functionAssociations.getItems()).isEmpty() || !functionAssociationsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (FunctionAssociation functionAssociationsItemsListValue : functionAssociationsItemsList) {
                                xmlWriter.startElement("FunctionAssociation");
                                if (functionAssociationsItemsListValue.getFunctionARN() != null) {
                                    xmlWriter.startElement("FunctionARN").value(functionAssociationsItemsListValue.getFunctionARN()).endElement();
                                }
                                if (functionAssociationsItemsListValue.getEventType() != null) {
                                    xmlWriter.startElement("EventType").value(functionAssociationsItemsListValue.getEventType()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getFieldLevelEncryptionId() != null) {
                        xmlWriter.startElement("FieldLevelEncryptionId").value(defaultCacheBehavior.getFieldLevelEncryptionId()).endElement();
                    }
                    if (defaultCacheBehavior.getRealtimeLogConfigArn() != null) {
                        xmlWriter.startElement("RealtimeLogConfigArn").value(defaultCacheBehavior.getRealtimeLogConfigArn()).endElement();
                    }
                    if (defaultCacheBehavior.getCachePolicyId() != null) {
                        xmlWriter.startElement("CachePolicyId").value(defaultCacheBehavior.getCachePolicyId()).endElement();
                    }
                    if (defaultCacheBehavior.getOriginRequestPolicyId() != null) {
                        xmlWriter.startElement("OriginRequestPolicyId").value(defaultCacheBehavior.getOriginRequestPolicyId()).endElement();
                    }
                    if (defaultCacheBehavior.getResponseHeadersPolicyId() != null) {
                        xmlWriter.startElement("ResponseHeadersPolicyId").value(defaultCacheBehavior.getResponseHeadersPolicyId()).endElement();
                    }
                    if ((forwardedValues = defaultCacheBehavior.getForwardedValues()) != null) {
                        Object queryStringCacheKeys;
                        Headers headers;
                        CookiePreference cookies;
                        xmlWriter.startElement("ForwardedValues");
                        if (forwardedValues.getQueryString() != null) {
                            xmlWriter.startElement("QueryString").value(forwardedValues.getQueryString()).endElement();
                        }
                        if ((cookies = forwardedValues.getCookies()) != null) {
                            CookieNames whitelistedNames;
                            xmlWriter.startElement("Cookies");
                            if (cookies.getForward() != null) {
                                xmlWriter.startElement("Forward").value(cookies.getForward()).endElement();
                            }
                            if ((whitelistedNames = cookies.getWhitelistedNames()) != null) {
                                Iterator cookieNamesItemsList;
                                xmlWriter.startElement("WhitelistedNames");
                                if (whitelistedNames.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(whitelistedNames.getQuantity()).endElement();
                                }
                                if (!((ArrayList)((Object)(cookieNamesItemsList = (SdkInternalList)whitelistedNames.getItems()))).isEmpty() || !((SdkInternalList)((Object)cookieNamesItemsList)).isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    originGroupMembersItemsList = ((ArrayList)((Object)cookieNamesItemsList)).iterator();
                                    while (originGroupMembersItemsList.hasNext()) {
                                        String cookieNamesItemsListValue = (String)originGroupMembersItemsList.next();
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value(cookieNamesItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((headers = forwardedValues.getHeaders()) != null) {
                            SdkInternalList headersItemsList;
                            xmlWriter.startElement("Headers");
                            if (headers.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value(headers.getQuantity()).endElement();
                            }
                            if (!(headersItemsList = (SdkInternalList)headers.getItems()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (String headersItemsListValue : headersItemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value(headersItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((queryStringCacheKeys = forwardedValues.getQueryStringCacheKeys()) != null) {
                            SdkInternalList queryStringCacheKeysItemsList;
                            xmlWriter.startElement("QueryStringCacheKeys");
                            if (((QueryStringCacheKeys)queryStringCacheKeys).getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value(((QueryStringCacheKeys)queryStringCacheKeys).getQuantity()).endElement();
                            }
                            if (!(queryStringCacheKeysItemsList = (SdkInternalList)((QueryStringCacheKeys)queryStringCacheKeys).getItems()).isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (String queryStringCacheKeysItemsListValue : queryStringCacheKeysItemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value(queryStringCacheKeysItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getMinTTL() != null) {
                        xmlWriter.startElement("MinTTL").value(defaultCacheBehavior.getMinTTL()).endElement();
                    }
                    if (defaultCacheBehavior.getDefaultTTL() != null) {
                        xmlWriter.startElement("DefaultTTL").value(defaultCacheBehavior.getDefaultTTL()).endElement();
                    }
                    if (defaultCacheBehavior.getMaxTTL() != null) {
                        xmlWriter.startElement("MaxTTL").value(defaultCacheBehavior.getMaxTTL()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((cacheBehaviors = distributionConfig.getCacheBehaviors()) != null) {
                    SdkInternalList cacheBehaviorsItemsList;
                    xmlWriter.startElement("CacheBehaviors");
                    if (cacheBehaviors.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(cacheBehaviors.getQuantity()).endElement();
                    }
                    if (!(cacheBehaviorsItemsList = (SdkInternalList)cacheBehaviors.getItems()).isEmpty() || !cacheBehaviorsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (CacheBehavior cacheBehaviorsItemsListValue : cacheBehaviorsItemsList) {
                            ForwardedValues forwardedValues;
                            FunctionAssociations functionAssociations;
                            LambdaFunctionAssociations lambdaFunctionAssociations;
                            Iterator cachedMethods;
                            AllowedMethods allowedMethods;
                            TrustedKeyGroups trustedKeyGroups;
                            TrustedSigners trustedSigners;
                            xmlWriter.startElement("CacheBehavior");
                            if (cacheBehaviorsItemsListValue.getPathPattern() != null) {
                                xmlWriter.startElement("PathPattern").value(cacheBehaviorsItemsListValue.getPathPattern()).endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getTargetOriginId() != null) {
                                xmlWriter.startElement("TargetOriginId").value(cacheBehaviorsItemsListValue.getTargetOriginId()).endElement();
                            }
                            if ((trustedSigners = cacheBehaviorsItemsListValue.getTrustedSigners()) != null) {
                                SdkInternalList trustedSignersItemsList;
                                xmlWriter.startElement("TrustedSigners");
                                if (trustedSigners.getEnabled() != null) {
                                    xmlWriter.startElement("Enabled").value(trustedSigners.getEnabled()).endElement();
                                }
                                if (trustedSigners.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(trustedSigners.getQuantity()).endElement();
                                }
                                if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.getItems()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                                        xmlWriter.startElement("AwsAccountNumber");
                                        xmlWriter.value(trustedSignersItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((trustedKeyGroups = cacheBehaviorsItemsListValue.getTrustedKeyGroups()) != null) {
                                SdkInternalList trustedKeyGroupsItemsList;
                                xmlWriter.startElement("TrustedKeyGroups");
                                if (trustedKeyGroups.getEnabled() != null) {
                                    xmlWriter.startElement("Enabled").value(trustedKeyGroups.getEnabled()).endElement();
                                }
                                if (trustedKeyGroups.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(trustedKeyGroups.getQuantity()).endElement();
                                }
                                if (!(trustedKeyGroupsItemsList = (SdkInternalList)trustedKeyGroups.getItems()).isEmpty() || !trustedKeyGroupsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (String trustedKeyGroupsItemsListValue : trustedKeyGroupsItemsList) {
                                        xmlWriter.startElement("KeyGroup");
                                        xmlWriter.value(trustedKeyGroupsItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getViewerProtocolPolicy() != null) {
                                xmlWriter.startElement("ViewerProtocolPolicy").value(cacheBehaviorsItemsListValue.getViewerProtocolPolicy()).endElement();
                            }
                            if ((allowedMethods = cacheBehaviorsItemsListValue.getAllowedMethods()) != null) {
                                SdkInternalList allowedMethodsItemsList;
                                xmlWriter.startElement("AllowedMethods");
                                if (allowedMethods.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(allowedMethods.getQuantity()).endElement();
                                }
                                if (!(allowedMethodsItemsList = (SdkInternalList)allowedMethods.getItems()).isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                        xmlWriter.startElement("Method");
                                        xmlWriter.value(allowedMethodsItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((cachedMethods = allowedMethods.getCachedMethods()) != null) {
                                    SdkInternalList cachedMethodsItemsList;
                                    xmlWriter.startElement("CachedMethods");
                                    if (((CachedMethods)((Object)cachedMethods)).getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(((CachedMethods)((Object)cachedMethods)).getQuantity()).endElement();
                                    }
                                    if (!(cachedMethodsItemsList = (SdkInternalList)((CachedMethods)((Object)cachedMethods)).getItems()).isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (String cachedMethodsItemsListValue : cachedMethodsItemsList) {
                                            xmlWriter.startElement("Method");
                                            xmlWriter.value(cachedMethodsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getSmoothStreaming() != null) {
                                xmlWriter.startElement("SmoothStreaming").value(cacheBehaviorsItemsListValue.getSmoothStreaming()).endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getCompress() != null) {
                                xmlWriter.startElement("Compress").value(cacheBehaviorsItemsListValue.getCompress()).endElement();
                            }
                            if ((lambdaFunctionAssociations = cacheBehaviorsItemsListValue.getLambdaFunctionAssociations()) != null) {
                                SdkInternalList lambdaFunctionAssociationsItemsList;
                                xmlWriter.startElement("LambdaFunctionAssociations");
                                if (lambdaFunctionAssociations.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(lambdaFunctionAssociations.getQuantity()).endElement();
                                }
                                if (!(lambdaFunctionAssociationsItemsList = (SdkInternalList)lambdaFunctionAssociations.getItems()).isEmpty() || !lambdaFunctionAssociationsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    cachedMethods = lambdaFunctionAssociationsItemsList.iterator();
                                    while (cachedMethods.hasNext()) {
                                        LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue = (LambdaFunctionAssociation)cachedMethods.next();
                                        xmlWriter.startElement("LambdaFunctionAssociation");
                                        if (lambdaFunctionAssociationsItemsListValue.getLambdaFunctionARN() != null) {
                                            xmlWriter.startElement("LambdaFunctionARN").value(lambdaFunctionAssociationsItemsListValue.getLambdaFunctionARN()).endElement();
                                        }
                                        if (lambdaFunctionAssociationsItemsListValue.getEventType() != null) {
                                            xmlWriter.startElement("EventType").value(lambdaFunctionAssociationsItemsListValue.getEventType()).endElement();
                                        }
                                        if (lambdaFunctionAssociationsItemsListValue.getIncludeBody() != null) {
                                            xmlWriter.startElement("IncludeBody").value(lambdaFunctionAssociationsItemsListValue.getIncludeBody()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((functionAssociations = cacheBehaviorsItemsListValue.getFunctionAssociations()) != null) {
                                SdkInternalList functionAssociationsItemsList;
                                xmlWriter.startElement("FunctionAssociations");
                                if (functionAssociations.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value(functionAssociations.getQuantity()).endElement();
                                }
                                if (!(functionAssociationsItemsList = (SdkInternalList)functionAssociations.getItems()).isEmpty() || !functionAssociationsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    cachedMethods = functionAssociationsItemsList.iterator();
                                    while (cachedMethods.hasNext()) {
                                        FunctionAssociation functionAssociationsItemsListValue = (FunctionAssociation)cachedMethods.next();
                                        xmlWriter.startElement("FunctionAssociation");
                                        if (functionAssociationsItemsListValue.getFunctionARN() != null) {
                                            xmlWriter.startElement("FunctionARN").value(functionAssociationsItemsListValue.getFunctionARN()).endElement();
                                        }
                                        if (functionAssociationsItemsListValue.getEventType() != null) {
                                            xmlWriter.startElement("EventType").value(functionAssociationsItemsListValue.getEventType()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getFieldLevelEncryptionId() != null) {
                                xmlWriter.startElement("FieldLevelEncryptionId").value(cacheBehaviorsItemsListValue.getFieldLevelEncryptionId()).endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getRealtimeLogConfigArn() != null) {
                                xmlWriter.startElement("RealtimeLogConfigArn").value(cacheBehaviorsItemsListValue.getRealtimeLogConfigArn()).endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getCachePolicyId() != null) {
                                xmlWriter.startElement("CachePolicyId").value(cacheBehaviorsItemsListValue.getCachePolicyId()).endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getOriginRequestPolicyId() != null) {
                                xmlWriter.startElement("OriginRequestPolicyId").value(cacheBehaviorsItemsListValue.getOriginRequestPolicyId()).endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getResponseHeadersPolicyId() != null) {
                                xmlWriter.startElement("ResponseHeadersPolicyId").value(cacheBehaviorsItemsListValue.getResponseHeadersPolicyId()).endElement();
                            }
                            if ((forwardedValues = cacheBehaviorsItemsListValue.getForwardedValues()) != null) {
                                QueryStringCacheKeys queryStringCacheKeys;
                                Headers headers;
                                CookiePreference cookies;
                                xmlWriter.startElement("ForwardedValues");
                                if (forwardedValues.getQueryString() != null) {
                                    xmlWriter.startElement("QueryString").value(forwardedValues.getQueryString()).endElement();
                                }
                                if ((cookies = forwardedValues.getCookies()) != null) {
                                    CookieNames whitelistedNames;
                                    xmlWriter.startElement("Cookies");
                                    if (cookies.getForward() != null) {
                                        xmlWriter.startElement("Forward").value(cookies.getForward()).endElement();
                                    }
                                    if ((whitelistedNames = cookies.getWhitelistedNames()) != null) {
                                        SdkInternalList cookieNamesItemsList;
                                        xmlWriter.startElement("WhitelistedNames");
                                        if (whitelistedNames.getQuantity() != null) {
                                            xmlWriter.startElement("Quantity").value(whitelistedNames.getQuantity()).endElement();
                                        }
                                        if (!(cookieNamesItemsList = (SdkInternalList)whitelistedNames.getItems()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                            xmlWriter.startElement("Items");
                                            for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                                xmlWriter.startElement("Name");
                                                xmlWriter.value(cookieNamesItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((headers = forwardedValues.getHeaders()) != null) {
                                    SdkInternalList headersItemsList;
                                    xmlWriter.startElement("Headers");
                                    if (headers.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(headers.getQuantity()).endElement();
                                    }
                                    if (!(headersItemsList = (SdkInternalList)headers.getItems()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (String headersItemsListValue : headersItemsList) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(headersItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((queryStringCacheKeys = forwardedValues.getQueryStringCacheKeys()) != null) {
                                    SdkInternalList queryStringCacheKeysItemsList;
                                    xmlWriter.startElement("QueryStringCacheKeys");
                                    if (queryStringCacheKeys.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value(queryStringCacheKeys.getQuantity()).endElement();
                                    }
                                    if (!(queryStringCacheKeysItemsList = (SdkInternalList)queryStringCacheKeys.getItems()).isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (String queryStringCacheKeysItemsListValue : queryStringCacheKeysItemsList) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(queryStringCacheKeysItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getMinTTL() != null) {
                                xmlWriter.startElement("MinTTL").value(cacheBehaviorsItemsListValue.getMinTTL()).endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getDefaultTTL() != null) {
                                xmlWriter.startElement("DefaultTTL").value(cacheBehaviorsItemsListValue.getDefaultTTL()).endElement();
                            }
                            if (cacheBehaviorsItemsListValue.getMaxTTL() != null) {
                                xmlWriter.startElement("MaxTTL").value(cacheBehaviorsItemsListValue.getMaxTTL()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((customErrorResponses = distributionConfig.getCustomErrorResponses()) != null) {
                    SdkInternalList customErrorResponsesItemsList;
                    xmlWriter.startElement("CustomErrorResponses");
                    if (customErrorResponses.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(customErrorResponses.getQuantity()).endElement();
                    }
                    if (!(customErrorResponsesItemsList = (SdkInternalList)customErrorResponses.getItems()).isEmpty() || !customErrorResponsesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (CustomErrorResponse customErrorResponsesItemsListValue : customErrorResponsesItemsList) {
                            xmlWriter.startElement("CustomErrorResponse");
                            if (customErrorResponsesItemsListValue.getErrorCode() != null) {
                                xmlWriter.startElement("ErrorCode").value(customErrorResponsesItemsListValue.getErrorCode()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getResponsePagePath() != null) {
                                xmlWriter.startElement("ResponsePagePath").value(customErrorResponsesItemsListValue.getResponsePagePath()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getResponseCode() != null) {
                                xmlWriter.startElement("ResponseCode").value(customErrorResponsesItemsListValue.getResponseCode()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getErrorCachingMinTTL() != null) {
                                xmlWriter.startElement("ErrorCachingMinTTL").value(customErrorResponsesItemsListValue.getErrorCachingMinTTL()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(distributionConfig.getComment()).endElement();
                }
                if ((logging = distributionConfig.getLogging()) != null) {
                    xmlWriter.startElement("Logging");
                    if (logging.getEnabled() != null) {
                        xmlWriter.startElement("Enabled").value(logging.getEnabled()).endElement();
                    }
                    if (logging.getIncludeCookies() != null) {
                        xmlWriter.startElement("IncludeCookies").value(logging.getIncludeCookies()).endElement();
                    }
                    if (logging.getBucket() != null) {
                        xmlWriter.startElement("Bucket").value(logging.getBucket()).endElement();
                    }
                    if (logging.getPrefix() != null) {
                        xmlWriter.startElement("Prefix").value(logging.getPrefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getPriceClass() != null) {
                    xmlWriter.startElement("PriceClass").value(distributionConfig.getPriceClass()).endElement();
                }
                if (distributionConfig.getEnabled() != null) {
                    xmlWriter.startElement("Enabled").value(distributionConfig.getEnabled()).endElement();
                }
                if ((viewerCertificate = distributionConfig.getViewerCertificate()) != null) {
                    xmlWriter.startElement("ViewerCertificate");
                    if (viewerCertificate.getCloudFrontDefaultCertificate() != null) {
                        xmlWriter.startElement("CloudFrontDefaultCertificate").value(viewerCertificate.getCloudFrontDefaultCertificate()).endElement();
                    }
                    if (viewerCertificate.getIAMCertificateId() != null) {
                        xmlWriter.startElement("IAMCertificateId").value(viewerCertificate.getIAMCertificateId()).endElement();
                    }
                    if (viewerCertificate.getACMCertificateArn() != null) {
                        xmlWriter.startElement("ACMCertificateArn").value(viewerCertificate.getACMCertificateArn()).endElement();
                    }
                    if (viewerCertificate.getSSLSupportMethod() != null) {
                        xmlWriter.startElement("SSLSupportMethod").value(viewerCertificate.getSSLSupportMethod()).endElement();
                    }
                    if (viewerCertificate.getMinimumProtocolVersion() != null) {
                        xmlWriter.startElement("MinimumProtocolVersion").value(viewerCertificate.getMinimumProtocolVersion()).endElement();
                    }
                    if (viewerCertificate.getCertificate() != null) {
                        xmlWriter.startElement("Certificate").value(viewerCertificate.getCertificate()).endElement();
                    }
                    if (viewerCertificate.getCertificateSource() != null) {
                        xmlWriter.startElement("CertificateSource").value(viewerCertificate.getCertificateSource()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((restrictions = distributionConfig.getRestrictions()) != null) {
                    xmlWriter.startElement("Restrictions");
                    GeoRestriction geoRestriction = restrictions.getGeoRestriction();
                    if (geoRestriction != null) {
                        SdkInternalList geoRestrictionItemsList;
                        xmlWriter.startElement("GeoRestriction");
                        if (geoRestriction.getRestrictionType() != null) {
                            xmlWriter.startElement("RestrictionType").value(geoRestriction.getRestrictionType()).endElement();
                        }
                        if (geoRestriction.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value(geoRestriction.getQuantity()).endElement();
                        }
                        if (!(geoRestrictionItemsList = (SdkInternalList)geoRestriction.getItems()).isEmpty() || !geoRestrictionItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String geoRestrictionItemsListValue : geoRestrictionItemsList) {
                                xmlWriter.startElement("Location");
                                xmlWriter.value(geoRestrictionItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getWebACLId() != null) {
                    xmlWriter.startElement("WebACLId").value(distributionConfig.getWebACLId()).endElement();
                }
                if (distributionConfig.getHttpVersion() != null) {
                    xmlWriter.startElement("HttpVersion").value(distributionConfig.getHttpVersion()).endElement();
                }
                if (distributionConfig.getIsIPV6Enabled() != null) {
                    xmlWriter.startElement("IsIPV6Enabled").value(distributionConfig.getIsIPV6Enabled()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

