/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.credentials.impl;

import java.util.ArrayList;
import java.util.List;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.mill.credentials.AccountCredentials;
import org.duracloud.mill.credentials.AccountCredentialsNotFoundException;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.CredentialsRepoException;
import org.duracloud.mill.credentials.StorageProviderCredentials;
import org.duracloud.mill.credentials.StorageProviderCredentialsNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultCredentialsRepoImpl
implements CredentialsRepo {
    private DuracloudAccountRepo accountRepo;

    @Autowired
    public DefaultCredentialsRepoImpl(DuracloudAccountRepo accountRepo) {
        this.accountRepo = accountRepo;
    }

    @Override
    public AccountCredentials getAccountCredentials(String account) throws AccountCredentialsNotFoundException {
        ArrayList<StorageProviderCredentials> creds = new ArrayList<StorageProviderCredentials>();
        AccountInfo accountInfo = this.accountRepo.findBySubdomain(account);
        if (accountInfo == null) {
            throw new AccountCredentialsNotFoundException("no account found for subdomain " + account);
        }
        creds.add(this.createStorageProviderCredentials(accountInfo.getPrimaryStorageProviderAccount(), true));
        for (StorageProviderAccount sp : accountInfo.getSecondaryStorageProviderAccounts()) {
            creds.add(this.createStorageProviderCredentials(sp, false));
        }
        AccountCredentials accountCreds = new AccountCredentials(account, creds);
        return accountCreds;
    }

    private StorageProviderCredentials createStorageProviderCredentials(StorageProviderAccount sp, boolean primary) {
        return this.createStorageProviderCredentials(sp.getId().toString(), sp, primary);
    }

    @Override
    public List<String> getActiveAccounts() throws CredentialsRepoException {
        List<AccountInfo> accountInfos = this.accountRepo.findByStatus(AccountInfo.AccountStatus.ACTIVE);
        ArrayList<String> subdomains = new ArrayList<String>();
        for (int i = accountInfos.size() - 1; i > -1; --i) {
            subdomains.add(0, accountInfos.remove(i).getSubdomain());
        }
        return subdomains;
    }

    @Override
    public StorageProviderCredentials getStorageProviderCredentials(String subdomain, String storeId) throws AccountCredentialsNotFoundException, StorageProviderCredentialsNotFoundException {
        AccountInfo account = this.accountRepo.findBySubdomain(subdomain);
        Long id = Long.valueOf(storeId);
        if (account == null) {
            throw new AccountCredentialsNotFoundException("no account found for subdomain " + subdomain);
        }
        StorageProviderAccount provider = account.getPrimaryStorageProviderAccount();
        if (provider.getId().equals(id)) {
            return this.createStorageProviderCredentials(storeId, provider, true);
        }
        for (StorageProviderAccount sp : account.getSecondaryStorageProviderAccounts()) {
            if (!sp.getId().equals(id)) continue;
            return this.createStorageProviderCredentials(storeId, sp, false);
        }
        throw new StorageProviderCredentialsNotFoundException("No storage provider on subdomain " + subdomain + " with storeId " + storeId + " found.");
    }

    private StorageProviderCredentials createStorageProviderCredentials(String storeId, StorageProviderAccount provider, boolean primary) {
        return new StorageProviderCredentials(storeId, provider.getUsername(), provider.getPassword(), provider.getProviderType(), provider.getProperties(), primary);
    }

    @Override
    public boolean isAccountActive(String account) throws AccountCredentialsNotFoundException {
        AccountInfo info = this.accountRepo.findBySubdomain(account);
        if (info == null) {
            throw new AccountCredentialsNotFoundException("no account found where accountId =  " + account);
        }
        return info.getStatus().equals((Object)AccountInfo.AccountStatus.ACTIVE);
    }
}

