/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.header.Header;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;
import org.springframework.util.ReflectionUtils;

public final class CacheControlHeadersWriter
implements HeaderWriter {
    private static final String EXPIRES = "Expires";
    private static final String PRAGMA = "Pragma";
    private static final String CACHE_CONTROL = "Cache-Control";
    private final Method getHeaderMethod;
    private final HeaderWriter delegate = new StaticHeadersWriter(CacheControlHeadersWriter.createHeaders());

    public CacheControlHeadersWriter() {
        this.getHeaderMethod = ReflectionUtils.findMethod(HttpServletResponse.class, "getHeader", String.class);
    }

    @Override
    public void writeHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.hasHeader(response, CACHE_CONTROL) || this.hasHeader(response, EXPIRES) || this.hasHeader(response, PRAGMA)) {
            return;
        }
        this.delegate.writeHeaders(request, response);
    }

    private boolean hasHeader(HttpServletResponse response, String headerName) {
        if (this.getHeaderMethod == null) {
            return false;
        }
        return ReflectionUtils.invokeMethod(this.getHeaderMethod, response, headerName) != null;
    }

    private static List<Header> createHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>(2);
        headers.add(new Header(CACHE_CONTROL, "no-cache, no-store, max-age=0, must-revalidate"));
        headers.add(new Header(PRAGMA, "no-cache"));
        headers.add(new Header(EXPIRES, "0"));
        return headers;
    }
}

