/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.glacierstorage;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.StorageClass;
import java.util.Map;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storage.StoragePolicy;
import org.duracloud.storage.domain.RetrievedContent;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.error.StorageStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlacierStorageProvider
extends S3StorageProvider {
    protected static final String INVALID_OBJECT_STATE = "InvalidObjectState";
    private final Logger log = LoggerFactory.getLogger(GlacierStorageProvider.class);

    public GlacierStorageProvider(String accessKey, String secretKey, Map<String, String> options) {
        super(accessKey, secretKey, options);
    }

    public GlacierStorageProvider(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    public GlacierStorageProvider(AmazonS3 s3Client, String accessKey) {
        super(s3Client, accessKey, null);
    }

    @Override
    public StorageProviderType getStorageProviderType() {
        return StorageProviderType.AMAZON_GLACIER;
    }

    @Override
    protected StoragePolicy getStoragePolicy() {
        return new StoragePolicy(StorageClass.Glacier, 0);
    }

    @Override
    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        try {
            return super.copyContent(sourceSpaceId, sourceContentId, destSpaceId, destContentId);
        }
        catch (StorageException e) {
            this.checkStorageState(e);
            throw e;
        }
    }

    @Override
    public RetrievedContent getContent(String spaceId, String contentId, String range) {
        this.log.debug("getContent(" + spaceId + ", " + contentId + ")");
        try {
            return super.getContent(spaceId, contentId, range);
        }
        catch (StorageException e) {
            this.checkStorageState(e);
            throw e;
        }
    }

    @Override
    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) {
        this.log.debug("setContentProperties(" + spaceId + ", " + contentId + ")");
        try {
            super.setContentProperties(spaceId, contentId, contentProperties);
        }
        catch (StorageException e) {
            this.checkStorageState(e);
            throw e;
        }
    }

    private void checkStorageState(StorageException e) {
        String errorCode;
        if (e.getCause() instanceof AmazonS3Exception && INVALID_OBJECT_STATE.equals(errorCode = ((AmazonS3Exception)e.getCause()).getErrorCode())) {
            String message = "The storage state of this content item does not allow for this action to be taken. To resolve this issue: 1. Request that this content item be retrieved from offline storage 2. Wait (retrieval may take up to 5 hours) 3. Retry this request";
            throw new StorageStateException(message, e);
        }
    }
}

