/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;

public final class DelegatingSecurityContextRepository
implements SecurityContextRepository {
    private final List<SecurityContextRepository> delegates;

    public DelegatingSecurityContextRepository(SecurityContextRepository ... delegates) {
        this(Arrays.asList(delegates));
    }

    public DelegatingSecurityContextRepository(List<SecurityContextRepository> delegates) {
        Assert.notEmpty(delegates, "delegates cannot be empty");
        this.delegates = delegates;
    }

    @Override
    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        SecurityContext result = null;
        for (SecurityContextRepository delegate : this.delegates) {
            SecurityContext delegateResult = delegate.loadContext(requestResponseHolder);
            if (result != null && !delegate.containsContext(requestResponseHolder.getRequest())) continue;
            result = delegateResult;
        }
        return result;
    }

    @Override
    public DeferredSecurityContext loadDeferredContext(HttpServletRequest request) {
        DeferredSecurityContext deferredSecurityContext = null;
        for (SecurityContextRepository delegate : this.delegates) {
            if (deferredSecurityContext == null) {
                deferredSecurityContext = delegate.loadDeferredContext(request);
                continue;
            }
            DeferredSecurityContext next = delegate.loadDeferredContext(request);
            deferredSecurityContext = new DelegatingDeferredSecurityContext(deferredSecurityContext, next);
        }
        return deferredSecurityContext;
    }

    @Override
    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        for (SecurityContextRepository delegate : this.delegates) {
            delegate.saveContext(context, request, response);
        }
    }

    @Override
    public boolean containsContext(HttpServletRequest request) {
        for (SecurityContextRepository delegate : this.delegates) {
            if (!delegate.containsContext(request)) continue;
            return true;
        }
        return false;
    }

    static final class DelegatingDeferredSecurityContext
    implements DeferredSecurityContext {
        private final DeferredSecurityContext previous;
        private final DeferredSecurityContext next;

        DelegatingDeferredSecurityContext(DeferredSecurityContext previous, DeferredSecurityContext next) {
            this.previous = previous;
            this.next = next;
        }

        @Override
        public SecurityContext get() {
            SecurityContext securityContext = (SecurityContext)this.previous.get();
            if (!this.previous.isGenerated()) {
                return securityContext;
            }
            return (SecurityContext)this.next.get();
        }

        @Override
        public boolean isGenerated() {
            return this.previous.isGenerated() && this.next.isGenerated();
        }
    }
}

