/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.RpcClientParams;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.UnroutableRpcRequestException;
import com.rabbitmq.client.impl.MethodArgumentReader;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import com.rabbitmq.client.impl.ValueReader;
import com.rabbitmq.client.impl.ValueWriter;
import com.rabbitmq.utility.BlockingCell;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcClient.class);
    private final Channel _channel;
    private final String _exchange;
    private final String _routingKey;
    private final String _replyTo;
    private final int _timeout;
    protected static final int NO_TIMEOUT = -1;
    private final boolean _useMandatory;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    public static final Function<Object, Response> DEFAULT_REPLY_HANDLER = reply -> {
        if (reply instanceof ShutdownSignalException) {
            ShutdownSignalException sig = (ShutdownSignalException)reply;
            ShutdownSignalException wrapper = new ShutdownSignalException(sig.isHardError(), sig.isInitiatedByApplication(), sig.getReason(), sig.getReference());
            wrapper.initCause(sig);
            throw wrapper;
        }
        if (reply instanceof UnroutableRpcRequestException) {
            throw (UnroutableRpcRequestException)reply;
        }
        return (Response)reply;
    };
    private final Function<Object, Response> _replyHandler;
    private final Map<String, BlockingCell<Object>> _continuationMap = new HashMap<String, BlockingCell<Object>>();
    private final Supplier<String> _correlationIdSupplier;
    private String lastCorrelationId = "0";
    private final DefaultConsumer _consumer;

    public RpcClient(RpcClientParams params) throws IOException {
        this._channel = params.getChannel();
        this._exchange = params.getExchange();
        this._routingKey = params.getRoutingKey();
        this._replyTo = params.getReplyTo();
        if (params.getTimeout() < -1) {
            throw new IllegalArgumentException("Timeout argument must be NO_TIMEOUT(-1) or non-negative.");
        }
        this._timeout = params.getTimeout();
        this._useMandatory = params.shouldUseMandatory();
        this._replyHandler = params.getReplyHandler();
        this._correlationIdSupplier = params.getCorrelationIdSupplier();
        this._consumer = this.setupConsumer();
        if (this._useMandatory) {
            this._channel.addReturnListener(returnMessage -> {
                Map<String, BlockingCell<Object>> map = this._continuationMap;
                synchronized (map) {
                    String replyId = returnMessage.getProperties().getCorrelationId();
                    BlockingCell<Object> blocker = this._continuationMap.remove(replyId);
                    if (blocker == null) {
                        LOGGER.warn("No outstanding request for correlation ID {}", (Object)replyId);
                    } else {
                        blocker.set(new UnroutableRpcRequestException(returnMessage));
                    }
                }
            });
        }
    }

    @Deprecated
    public RpcClient(Channel channel, String exchange2, String routingKey, String replyTo, int timeout) throws IOException {
        this(new RpcClientParams().channel(channel).exchange(exchange2).routingKey(routingKey).replyTo(replyTo).timeout(timeout).useMandatory(false));
    }

    @Deprecated
    public RpcClient(Channel channel, String exchange2, String routingKey, String replyTo) throws IOException {
        this(channel, exchange2, routingKey, replyTo, -1);
    }

    @Deprecated
    public RpcClient(Channel channel, String exchange2, String routingKey) throws IOException {
        this(channel, exchange2, routingKey, "amq.rabbitmq.reply-to", -1);
    }

    @Deprecated
    public RpcClient(Channel channel, String exchange2, String routingKey, int timeout) throws IOException {
        this(channel, exchange2, routingKey, "amq.rabbitmq.reply-to", timeout);
    }

    private void checkNotClosed() throws IOException {
        if (this.closed.get()) {
            throw new EOFException("RpcClient is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this._channel.basicCancel(this._consumer.getConsumerTag());
        }
    }

    protected DefaultConsumer setupConsumer() throws IOException {
        DefaultConsumer consumer = new DefaultConsumer(this._channel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleShutdownSignal(String consumerTag, ShutdownSignalException signal) {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    for (Map.Entry entry : RpcClient.this._continuationMap.entrySet()) {
                        ((BlockingCell)entry.getValue()).set(signal);
                    }
                    RpcClient.this.closed.set(true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                Map map = RpcClient.this._continuationMap;
                synchronized (map) {
                    String replyId = properties.getCorrelationId();
                    BlockingCell blocker = (BlockingCell)RpcClient.this._continuationMap.remove(replyId);
                    if (blocker == null) {
                        LOGGER.warn("No outstanding request for correlation ID {}", (Object)replyId);
                    } else {
                        blocker.set(new Response(consumerTag, envelope, properties, body));
                    }
                }
            }
        };
        this._channel.basicConsume(this._replyTo, true, consumer);
        return consumer;
    }

    public void publish(AMQP.BasicProperties props, byte[] message) throws IOException {
        this._channel.basicPublish(this._exchange, this._routingKey, this._useMandatory, props, message);
    }

    public Response doCall(AMQP.BasicProperties props, byte[] message) throws IOException, TimeoutException {
        return this.doCall(props, message, this._timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doCall(AMQP.BasicProperties props, byte[] message, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        Object reply;
        String replyId;
        this.checkNotClosed();
        BlockingCell k = new BlockingCell();
        Map<String, BlockingCell<Object>> map = this._continuationMap;
        synchronized (map) {
            this.lastCorrelationId = replyId = this._correlationIdSupplier.get();
            props = (props == null ? new AMQP.BasicProperties.Builder() : props.builder()).correlationId(replyId).replyTo(this._replyTo).build();
            this._continuationMap.put(replyId, k);
        }
        this.publish(props, message);
        try {
            reply = k.uninterruptibleGet(timeout);
        }
        catch (TimeoutException ex) {
            this._continuationMap.remove(replyId);
            throw ex;
        }
        return this._replyHandler.apply(reply);
    }

    public byte[] primitiveCall(AMQP.BasicProperties props, byte[] message) throws IOException, ShutdownSignalException, TimeoutException {
        return this.primitiveCall(props, message, this._timeout);
    }

    public byte[] primitiveCall(AMQP.BasicProperties props, byte[] message, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        return this.doCall(props, message, timeout).getBody();
    }

    public byte[] primitiveCall(byte[] message) throws IOException, ShutdownSignalException, TimeoutException {
        return this.primitiveCall(null, message);
    }

    public Response responseCall(byte[] message) throws IOException, ShutdownSignalException, TimeoutException {
        return this.responseCall(message, this._timeout);
    }

    public Response responseCall(byte[] message, int timeout) throws IOException, ShutdownSignalException, TimeoutException {
        return this.doCall(null, message, timeout);
    }

    public String stringCall(String message) throws IOException, ShutdownSignalException, TimeoutException {
        byte[] request;
        try {
            request = message.getBytes("UTF-8");
        }
        catch (IOException _e) {
            request = message.getBytes();
        }
        byte[] reply = this.primitiveCall(request);
        try {
            return new String(reply, "UTF-8");
        }
        catch (IOException _e) {
            return new String(reply);
        }
    }

    public Map<String, Object> mapCall(Map<String, Object> message) throws IOException, ShutdownSignalException, TimeoutException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MethodArgumentWriter writer = new MethodArgumentWriter(new ValueWriter(new DataOutputStream(buffer)));
        writer.writeTable(message);
        writer.flush();
        byte[] reply = this.primitiveCall(buffer.toByteArray());
        MethodArgumentReader reader = new MethodArgumentReader(new ValueReader(new DataInputStream(new ByteArrayInputStream(reply))));
        return reader.readTable();
    }

    public Map<String, Object> mapCall(Object[] keyValuePairs) throws IOException, ShutdownSignalException, TimeoutException {
        HashMap<String, Object> message = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            message.put((String)keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return this.mapCall(message);
    }

    public Channel getChannel() {
        return this._channel;
    }

    public String getExchange() {
        return this._exchange;
    }

    public String getRoutingKey() {
        return this._routingKey;
    }

    public Map<String, BlockingCell<Object>> getContinuationMap() {
        return this._continuationMap;
    }

    public int getCorrelationId() {
        return Integer.valueOf(this.lastCorrelationId);
    }

    public Consumer getConsumer() {
        return this._consumer;
    }

    public static Supplier<String> incrementingCorrelationIdSupplier() {
        return RpcClient.incrementingCorrelationIdSupplier("");
    }

    public static Supplier<String> incrementingCorrelationIdSupplier(String prefix) {
        return new IncrementingCorrelationIdSupplier(prefix);
    }

    private static class IncrementingCorrelationIdSupplier
    implements Supplier<String> {
        private final String prefix;
        private int correlationId;

        public IncrementingCorrelationIdSupplier(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String get() {
            return this.prefix + ++this.correlationId;
        }
    }

    public static class Response {
        protected String consumerTag;
        protected Envelope envelope;
        protected AMQP.BasicProperties properties;
        protected byte[] body;

        public Response() {
        }

        public Response(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
            this.consumerTag = consumerTag;
            this.envelope = envelope;
            this.properties = properties;
            this.body = body;
        }

        public String getConsumerTag() {
            return this.consumerTag;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public AMQP.BasicProperties getProperties() {
            return this.properties;
        }

        public byte[] getBody() {
            return this.body;
        }
    }
}

