/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp.dup;

import java.text.MessageFormat;
import org.duracloud.mill.ltp.RunStats;

public class DuplicationRunStats
extends RunStats {
    private int deletes = 0;
    private int dups = 0;

    @Override
    public void reset() {
        this.deletes = 0;
        this.dups = 0;
    }

    public int getDups() {
        return this.dups;
    }

    public int getDeletes() {
        return this.deletes;
    }

    @Override
    public void copyValuesFrom(RunStats runstats) {
        DuplicationRunStats dstats = (DuplicationRunStats)runstats;
        this.deletes = dstats.deletes;
        this.dups = dstats.dups;
    }

    @Override
    public void add(RunStats stats) {
        DuplicationRunStats dstats = (DuplicationRunStats)stats;
        this.addToDeletes(dstats.deletes);
        this.addToDups(dstats.dups);
    }

    public void addToDups(int dupsToAdd) {
        this.dups += dupsToAdd;
    }

    public void addToDeletes(int deletesToAdd) {
        this.deletes += deletesToAdd;
    }

    public String toString() {
        return MessageFormat.format("delete_messages={0} duplication_messages={1}", this.deletes, this.dups);
    }
}

