/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityListeners;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.TableGenerator;
import org.dom4j.Element;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.java.JavaMetadataProvider;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.ClassLoaderAccessDelegateImpl;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.cfg.annotations.reflection.JPAOverriddenAnnotationReader;
import org.hibernate.cfg.annotations.reflection.XMLContext;

public final class JPAMetadataProvider
implements MetadataProvider {
    private static final MetadataProvider STATELESS_BASE_DELEGATE = new JavaMetadataProvider();
    private final ClassLoaderAccess classLoaderAccess;
    private final XMLContext xmlContext;
    private final boolean xmlMappingEnabled;
    private Map<Object, Object> defaults;
    private Map<AnnotatedElement, AnnotationReader> cache;

    @Deprecated
    public JPAMetadataProvider(final MetadataBuildingOptions metadataBuildingOptions) {
        this(new ClassLoaderAccessDelegateImpl(){
            ClassLoaderAccess delegate;

            @Override
            protected ClassLoaderAccess getDelegate() {
                if (this.delegate == null) {
                    this.delegate = new ClassLoaderAccessImpl(metadataBuildingOptions.getTempClassLoader(), metadataBuildingOptions.getServiceRegistry().getService(ClassLoaderService.class));
                }
                return this.delegate;
            }
        }, metadataBuildingOptions.isXmlMappingEnabled());
    }

    public JPAMetadataProvider(BootstrapContext bootstrapContext) {
        this(bootstrapContext.getClassLoaderAccess(), bootstrapContext.getMetadataBuildingOptions().isXmlMappingEnabled());
    }

    JPAMetadataProvider(ClassLoaderAccess classLoaderAccess, boolean xmlMetadataEnabled) {
        this.classLoaderAccess = classLoaderAccess;
        this.xmlContext = new XMLContext(classLoaderAccess);
        this.xmlMappingEnabled = xmlMetadataEnabled;
    }

    @Override
    public AnnotationReader getAnnotationReader(AnnotatedElement annotatedElement) {
        AnnotationReader reader;
        if (this.cache == null) {
            this.cache = new HashMap<AnnotatedElement, AnnotationReader>(50);
        }
        if ((reader = this.cache.get(annotatedElement)) == null) {
            reader = this.xmlContext.hasContext() ? new JPAOverriddenAnnotationReader(annotatedElement, this.xmlContext, this.classLoaderAccess) : STATELESS_BASE_DELEGATE.getAnnotationReader(annotatedElement);
            this.cache.put(annotatedElement, reader);
        }
        return reader;
    }

    @Override
    public void reset() {
        this.cache = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<Object, Object> getDefaults() {
        if (!this.xmlMappingEnabled) {
            return Collections.emptyMap();
        }
        if (this.defaults == null) {
            this.defaults = new HashMap<Object, Object>();
            XMLContext.Default xmlDefaults = this.xmlContext.getDefault(null);
            this.defaults.put("schema", xmlDefaults.getSchema());
            this.defaults.put("catalog", xmlDefaults.getCatalog());
            this.defaults.put("delimited-identifier", xmlDefaults.getDelimitedIdentifier());
            this.defaults.put("cascade-persist", xmlDefaults.getCascadePersist());
            ArrayList entityListeners = new ArrayList();
            for (String className : this.xmlContext.getDefaultEntityListeners()) {
                try {
                    entityListeners.add(this.classLoaderAccess.classForName(className));
                }
                catch (ClassLoadingException e) {
                    throw new IllegalStateException("Default entity listener class not found: " + className);
                }
            }
            this.defaults.put(EntityListeners.class, entityListeners);
            for (Element element : this.xmlContext.getAllDocuments()) {
                void var8_9;
                List<Element> elements = element.elements("sequence-generator");
                ArrayList<SequenceGenerator> sequenceGenerators = (ArrayList<SequenceGenerator>)this.defaults.get(SequenceGenerator.class);
                if (sequenceGenerators == null) {
                    sequenceGenerators = new ArrayList<SequenceGenerator>();
                    this.defaults.put(SequenceGenerator.class, sequenceGenerators);
                }
                for (Element element2 : elements) {
                    sequenceGenerators.add(JPAOverriddenAnnotationReader.buildSequenceGeneratorAnnotation(element2));
                }
                elements = element.elements("table-generator");
                ArrayList<TableGenerator> tableGenerators = (ArrayList<TableGenerator>)this.defaults.get(TableGenerator.class);
                if (tableGenerators == null) {
                    tableGenerators = new ArrayList<TableGenerator>();
                    this.defaults.put(TableGenerator.class, tableGenerators);
                }
                for (Element subelement3 : elements) {
                    tableGenerators.add(JPAOverriddenAnnotationReader.buildTableGeneratorAnnotation(subelement3, xmlDefaults));
                }
                List list = (List)this.defaults.get(NamedQuery.class);
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    this.defaults.put(NamedQuery.class, arrayList);
                }
                List currentNamedQueries = JPAOverriddenAnnotationReader.buildNamedQueries(element, false, xmlDefaults, this.classLoaderAccess);
                var8_9.addAll(currentNamedQueries);
                ArrayList namedNativeQueries = (ArrayList)this.defaults.get(NamedNativeQuery.class);
                if (namedNativeQueries == null) {
                    namedNativeQueries = new ArrayList();
                    this.defaults.put(NamedNativeQuery.class, namedNativeQueries);
                }
                List currentNamedNativeQueries = JPAOverriddenAnnotationReader.buildNamedQueries(element, true, xmlDefaults, this.classLoaderAccess);
                namedNativeQueries.addAll(currentNamedNativeQueries);
                ArrayList<SqlResultSetMapping> sqlResultSetMappings = (ArrayList<SqlResultSetMapping>)this.defaults.get(SqlResultSetMapping.class);
                if (sqlResultSetMappings == null) {
                    sqlResultSetMappings = new ArrayList<SqlResultSetMapping>();
                    this.defaults.put(SqlResultSetMapping.class, sqlResultSetMappings);
                }
                List<SqlResultSetMapping> currentSqlResultSetMappings = JPAOverriddenAnnotationReader.buildSqlResultsetMappings(element, xmlDefaults, this.classLoaderAccess);
                sqlResultSetMappings.addAll(currentSqlResultSetMappings);
                ArrayList<NamedStoredProcedureQuery> namedStoredProcedureQueries = (ArrayList<NamedStoredProcedureQuery>)this.defaults.get(NamedStoredProcedureQuery.class);
                if (namedStoredProcedureQueries == null) {
                    namedStoredProcedureQueries = new ArrayList<NamedStoredProcedureQuery>();
                    this.defaults.put(NamedStoredProcedureQuery.class, namedStoredProcedureQueries);
                }
                List<NamedStoredProcedureQuery> currentNamedStoredProcedureQueries = JPAOverriddenAnnotationReader.buildNamedStoreProcedureQueries(element, xmlDefaults, this.classLoaderAccess);
                namedStoredProcedureQueries.addAll(currentNamedStoredProcedureQueries);
            }
        }
        return this.defaults;
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }
}

