/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.util.Assert;

public final class XXssProtectionHeaderWriter
implements HeaderWriter {
    private static final String XSS_PROTECTION_HEADER = "X-XSS-Protection";
    private HeaderValue headerValue = HeaderValue.ENABLED_MODE_BLOCK;

    @Override
    public void writeHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (!response.containsHeader(XSS_PROTECTION_HEADER)) {
            response.setHeader(XSS_PROTECTION_HEADER, this.headerValue.toString());
        }
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.headerValue = HeaderValue.DISABLED;
        } else if (this.headerValue == HeaderValue.DISABLED) {
            this.headerValue = HeaderValue.ENABLED;
        }
    }

    @Deprecated
    public void setBlock(boolean block) {
        if (this.headerValue == HeaderValue.DISABLED && block) {
            throw new IllegalArgumentException("Cannot set block to true with enabled false");
        }
        this.headerValue = block ? HeaderValue.ENABLED_MODE_BLOCK : HeaderValue.ENABLED;
    }

    public void setHeaderValue(HeaderValue headerValue) {
        Assert.notNull((Object)headerValue, "headerValue cannot be null");
        this.headerValue = headerValue;
    }

    public String toString() {
        return this.getClass().getName() + " [headerValue=" + (Object)((Object)this.headerValue) + "]";
    }

    public static enum HeaderValue {
        DISABLED("0"),
        ENABLED("1"),
        ENABLED_MODE_BLOCK("1; mode=block");

        private final String value;

        private HeaderValue(String value) {
            this.value = value;
        }

        public static HeaderValue from(String headerValue) {
            for (HeaderValue value : HeaderValue.values()) {
                if (!value.toString().equals(headerValue)) continue;
                return value;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

