/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp;

import java.text.ParseException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.duracloud.mill.ltp.Frequency;
import org.duracloud.mill.ltp.LoopingTaskProducer;
import org.duracloud.mill.util.CommonCommandLineOptions;
import org.duracloud.mill.util.DriverSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoopingTaskProducerDriverSupport
extends DriverSupport {
    private static Logger log = LoggerFactory.getLogger(LoopingTaskProducerDriverSupport.class);

    public LoopingTaskProducerDriverSupport(CommonCommandLineOptions options) {
        super((Options)options);
    }

    protected final void executeImpl(CommandLine cmd) {
        try {
            LoopingTaskProducer producer = this.buildTaskProducer();
            producer.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error(ex.getMessage(), (Throwable)ex);
            System.exit(1);
        }
        log.info("looping task producer completed successfully.");
        System.exit(0);
    }

    protected abstract LoopingTaskProducer buildTaskProducer();

    protected int getMaxQueueSize(String key) {
        String maxTaskQueueSizeOption = System.getProperty(key);
        int maxTaskQueueSize = 10000;
        if (maxTaskQueueSizeOption != null) {
            maxTaskQueueSize = Integer.valueOf(maxTaskQueueSizeOption);
        }
        log.info("max task queue size: {}", (Object)maxTaskQueueSize);
        return maxTaskQueueSize;
    }

    protected String getTaskQueueName(String key) {
        return System.getProperty(key);
    }

    protected Frequency getFrequency(String key) {
        String frequencyStr = System.getProperty(key);
        if (frequencyStr == null) {
            frequencyStr = "1m";
        }
        Frequency frequency = null;
        try {
            frequency = new Frequency(frequencyStr);
            log.info("frequency = {}{}", (Object)frequency.getValue(), (Object)frequency.getTimeUnitAsString());
        }
        catch (ParseException ex) {
            System.out.println("Frequency parameter is invalid: " + frequency + " Please refer to usage for valid examples.");
            this.die();
        }
        return frequency;
    }
}

