/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.mill.common.storageprovider.StorageProviderFactory;
import org.duracloud.mill.credentials.AccountCredentialsNotFoundException;
import org.duracloud.mill.credentials.CredentialsRepo;
import org.duracloud.mill.credentials.CredentialsRepoException;
import org.duracloud.mill.credentials.StorageProviderCredentials;
import org.duracloud.mill.ltp.Frequency;
import org.duracloud.mill.ltp.LoopingTaskProducerConfigurationManager;
import org.duracloud.mill.ltp.Morsel;
import org.duracloud.mill.ltp.MorselQueue;
import org.duracloud.mill.ltp.RunStats;
import org.duracloud.mill.ltp.StateManager;
import org.duracloud.mill.notification.NotificationManager;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoopingTaskProducer<T extends Morsel>
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(LoopingTaskProducer.class);
    private TaskQueue taskQueue;
    private CredentialsRepo credentialsRepo;
    private StateManager<T> stateManager;
    private int maxTaskQueueSize;
    private StorageProviderFactory storageProviderFactory;
    private List<T> morselsToReload = new LinkedList<T>();
    private Frequency frequency;
    private LocalTime startTime;
    private RunStats cumulativeTotals;
    private NotificationManager notificationManager;
    private LoopingTaskProducerConfigurationManager config;
    private Map<String, RunStats> runstats = new HashMap<String, RunStats>();

    public LoopingTaskProducer(CredentialsRepo credentialsRepo, StorageProviderFactory storageProviderFactory, TaskQueue taskQueue, StateManager<T> state, int maxTaskQueueSize, Frequency frequency, LocalTime startTime, NotificationManager notificationManager, LoopingTaskProducerConfigurationManager config) {
        this.credentialsRepo = credentialsRepo;
        this.storageProviderFactory = storageProviderFactory;
        this.taskQueue = taskQueue;
        this.stateManager = state;
        this.credentialsRepo = credentialsRepo;
        this.maxTaskQueueSize = maxTaskQueueSize;
        this.frequency = frequency;
        this.startTime = startTime;
        this.cumulativeTotals = this.createRunStats();
        this.notificationManager = notificationManager;
        this.config = config;
    }

    protected Frequency getFrequency() {
        return this.frequency;
    }

    protected CredentialsRepo getCredentialsRepo() {
        return this.credentialsRepo;
    }

    protected TaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    protected int getMaxTaskQueueSize() {
        return this.maxTaskQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Timer timer = new Timer();
        try {
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    LoopingTaskProducer.this.logSessionStats();
                }
            }, 300000L, 300000L);
            if (this.runLater()) {
                return;
            }
            log.info("Starting run...");
            Queue<T> morselQueue = this.loadMorselQueue();
            while (!morselQueue.isEmpty() && this.taskQueue.size() < this.maxTaskQueueSize) {
                Morsel morsel = (Morsel)morselQueue.peek();
                if (morsel != null) {
                    String account = morsel.getAccount();
                    try {
                        if (!this.credentialsRepo.isAccountActive(account)) {
                            if (morsel.getMarker() == null) {
                                log.info("account {} has become inactive.  Abandonning morsel {}.", (Object)account, (Object)morsel);
                                morselQueue.poll();
                                continue;
                            }
                            String message = MessageFormat.format("account {0} has become inactive in the middle of processing {1}.   Allowing this morsel to continue but failure is likely.  \nExpect items to appear in the dead letter queue shortly.", account, morsel);
                            log.warn(message);
                            this.sendEmail(this.getSimpleName() + " attempting into account after start of morsel processing.", message);
                        }
                    }
                    catch (AccountCredentialsNotFoundException ex) {
                        String message = MessageFormat.format("account {0} does not exist.  Abandonning morsel {1}.", account, morsel);
                        log.warn(message);
                        this.sendEmail(this.getSimpleName() + " attempted to access into non-existent account", message);
                    }
                }
                this.nibble(morselQueue);
                this.persistMorsels(morselQueue, this.morselsToReload);
                if (morselQueue.isEmpty()) {
                    morselQueue = this.reloadMorselQueue();
                    continue;
                }
                if (!morsel.equals(morselQueue.peek())) continue;
                break;
            }
            this.logSessionStats();
            if (morselQueue.isEmpty()) {
                this.scheduleNextRun();
                this.writeCompletionFile();
            }
            log.info("Session ended.");
        }
        catch (Exception ex) {
            log.error("failed to complete run on " + this.getSimpleName() + ": " + ex.getMessage(), (Throwable)ex);
            this.sendEmail("failed to complete run on " + this.getSimpleName(), ex.getMessage());
        }
        finally {
            timer.cancel();
        }
    }

    private String getSimpleName() {
        return this.getClass().getSimpleName();
    }

    private void writeCompletionFile() {
        File completionFile = this.getCompletionFile();
        try {
            if (completionFile.createNewFile()) {
                log.info("successfully created completion marker file: {}", (Object)completionFile.getAbsolutePath());
            } else {
                log.warn("completion marker file unexpectably exists already - something may be amiss: {}", (Object)completionFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error("Unable to create the completion file {}: {}", (Object)completionFile.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    private void deleteCompletionFileIfExists() {
        File completionFile = this.getCompletionFile();
        if (completionFile.exists()) {
            completionFile.delete();
        }
    }

    private File getCompletionFile() {
        return new File(this.config.getWorkDirectoryPath(), this.getLoopingProducerTypePrefix() + "-producer-complete.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIncrementalSessionStats() {
        Map<String, RunStats> map = this.runstats;
        synchronized (map) {
            for (String account : this.runstats.keySet()) {
                RunStats stats = this.runstats.get(account);
                stats.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunStats calculateStatTotals(RunStats currentTotals) {
        RunStats totals = this.createRunStats();
        totals.copyValuesFrom(currentTotals);
        Map<String, RunStats> map = this.runstats;
        synchronized (map) {
            for (String account : this.runstats.keySet()) {
                RunStats stats = this.runstats.get(account);
                totals.add(stats);
            }
            return totals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSessionStats() {
        Map<String, RunStats> map = this.runstats;
        synchronized (map) {
            for (String account : this.runstats.keySet()) {
                RunStats stats = this.runstats.get(account);
                this.logIncrementalStatsByAccount(account, stats);
            }
            RunStats incrementalTotals = this.calculateStatTotals(this.createRunStats());
            this.logGlobalncrementalStats(incrementalTotals);
            this.cumulativeTotals = this.calculateStatTotals(this.cumulativeTotals);
            this.logCumulativeSessionStats(this.runstats, this.cumulativeTotals);
            this.resetIncrementalSessionStats();
        }
    }

    private void scheduleNextRun() {
        Date currentStartDate = this.stateManager.getCurrentRunStartDate();
        Date nextRun = this.calculateNextRunDate(currentStartDate);
        this.stateManager.setNextRunStartDate(nextRun);
        this.stateManager.setCurrentRunStartDate(null);
        String hostname = "unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("unable to get hostname:" + e.getMessage());
        }
        String subject = this.getClass().getSimpleName() + "'s run completed on " + hostname;
        StringBuilder builder = new StringBuilder();
        builder.append(subject + "\n");
        builder.append(this.cumulativeTotals.toString() + "\n");
        if (nextRun != null) {
            builder.append("Scheduling the next run for " + nextRun + "\n");
            log.info(subject + ": next run will start " + nextRun);
        }
        this.sendEmail(subject, builder.toString());
    }

    private Date calculateNextRunDate(Date previousDate) {
        Date nextRun;
        Calendar c = Calendar.getInstance();
        if (previousDate == null) {
            if (this.startTime != null) {
                c.set(11, this.startTime.getHour());
                c.set(12, this.startTime.getMinute());
                c.set(13, this.startTime.getSecond());
                LocalTime now = LocalTime.now();
                if (this.startTime.isBefore(now)) {
                    LocalTime startTimePlusTen = LocalTime.of(this.startTime.getHour(), this.startTime.getMinute() + 10, this.startTime.getSecond());
                    if (startTimePlusTen.isAfter(now)) {
                        log.info("Less than 10 minutes has passed since the scheduled start time, allowing run to begin now.");
                    } else {
                        log.info("The start time has passed for today. Setting next run to occur tomorrow");
                        c.add(5, 1);
                    }
                }
                nextRun = c.getTime();
            } else {
                nextRun = new Date();
            }
        } else {
            c.setTimeInMillis(previousDate.getTime());
            c.add(this.frequency.getTimeUnit(), this.frequency.getValue());
            nextRun = c.getTime();
        }
        if (this.frequency.getValue() <= 0) {
            nextRun = null;
        }
        return nextRun;
    }

    protected void sendEmail(String subject, String body) {
        this.notificationManager.sendEmail(subject, body);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean runLater() {
        boolean runLater = true;
        Date nextRun = this.stateManager.getNextRunStartDate();
        if (nextRun != null) {
            Date now = new Date();
            if (this.getFrequency().getValue() <= 0) {
                log.info("The frequency is set to {}: all scheduled runs will be cancelled.", (Object)this.getFrequency());
                this.stateManager.setNextRunStartDate(null);
                return runLater;
            }
            if (now.after(nextRun)) {
                this.deleteCompletionFileIfExists();
                this.stateManager.setCurrentRunStartDate(now);
                this.stateManager.setNextRunStartDate(null);
                runLater = false;
                log.info("Time to start a new run: the next run was scheduled to run on {}. Let's roll.", (Object)nextRun);
                return runLater;
            }
            log.info("It's not yet time start a new run: the next run is scheduled to run on {}.", (Object)nextRun);
            return runLater;
        }
        Date currentRunStartDate = this.stateManager.getCurrentRunStartDate();
        if (currentRunStartDate == null && this.getFrequency().getValue() <= 0) {
            log.info("The frequency is set to {}: no future runs will be scheduled.", (Object)this.getFrequency());
            return runLater;
        }
        if (currentRunStartDate == null) {
            Date startDate = this.calculateNextRunDate(null);
            if (startDate.getTime() > System.currentTimeMillis()) {
                this.stateManager.setNextRunStartDate(startDate);
                log.info("We will start the first run on this machine at {}", (Object)startDate);
                return true;
            }
            this.stateManager.setCurrentRunStartDate(startDate);
            log.info("We're starting the first run on this machine");
            return false;
        } else {
            log.info("We're continuing the current run which was started on {}", (Object)currentRunStartDate);
        }
        return false;
    }

    private MorselQueue<T> reloadMorselQueue() {
        List<T> morsels = this.morselsToReload;
        this.morselsToReload = new LinkedList<T>();
        MorselQueue queue = new MorselQueue();
        queue.addAll(morsels);
        return queue;
    }

    private Queue<T> loadMorselQueue() {
        Queue<T> morselQueue = this.createQueue();
        LinkedHashSet<T> morsels = new LinkedHashSet<T>(this.stateManager.getMorsels());
        morselQueue.addAll(morsels);
        if (morselQueue.isEmpty()) {
            this.loadMorselQueueFromSource(morselQueue);
        }
        return morselQueue;
    }

    protected Queue<T> createQueue() {
        return new LinkedList();
    }

    private void persistMorsels(Queue<T> queue, List<T> morselsToReload) {
        LinkedHashSet<T> morsels = new LinkedHashSet<T>();
        morsels.addAll(queue);
        morsels.addAll(morselsToReload);
        this.stateManager.setMorsels(morsels);
    }

    protected void addToReloadList(T morsel) {
        log.info("adding morsel to reload list: {}", morsel);
        this.morselsToReload.add(morsel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunStats getStats(String account) {
        Map<String, RunStats> map = this.runstats;
        synchronized (map) {
            RunStats stats = this.runstats.get(account);
            if (stats == null) {
                stats = this.createRunStats();
                this.runstats.put(account, stats);
            }
            return stats;
        }
    }

    protected StorageProvider getStorageProvider(String account, String storeId) {
        StorageProviderCredentials creds;
        try {
            creds = this.credentialsRepo.getStorageProviderCredentials(account, storeId);
        }
        catch (CredentialsRepoException e) {
            throw new RuntimeException(e);
        }
        return this.getStorageProvider(creds);
    }

    protected StorageProvider getStorageProvider(StorageProviderCredentials creds) {
        return this.storageProviderFactory.create(creds);
    }

    protected abstract void loadMorselQueueFromSource(Queue<T> var1);

    protected abstract void nibble(Queue<T> var1);

    protected abstract RunStats createRunStats();

    protected abstract void logGlobalncrementalStats(RunStats var1);

    protected abstract void logIncrementalStatsByAccount(String var1, RunStats var2);

    protected abstract void logCumulativeSessionStats(Map<String, RunStats> var1, RunStats var2);

    protected abstract String getLoopingProducerTypePrefix();

    protected void sendEmail(String message, Exception ex) {
        StackTraceElement[] stackTrace = ex.getStackTrace();
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement ste : stackTrace) {
            builder.append(ste.toString() + "\n");
        }
        this.sendEmail(message, builder.toString());
    }
}

