/*
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 *     http://duracloud.org/license/
 */
package org.duracloud.mill.ltp;

import java.util.PriorityQueue;

/**
 * A queue for <code>Morsels</code>
 *
 * @author Daniel Bernstein
 * Date: Nov 7, 2013
 */
public class MorselQueue<T extends Morsel> extends PriorityQueue<T> {
    public MorselQueue() {
        // there should never be anywhere near this number of morsels in the queue;
        super(100000, new MorselComparator());
    }
}
