/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.ltp;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.commons.io.FileUtils;
import org.duracloud.mill.ltp.Morsel;
import org.duracloud.mill.ltp.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateManager<T extends Morsel> {
    private static Logger log = LoggerFactory.getLogger(StateManager.class);
    private File stateFile;
    private File tempStateFile;
    private State<T> state = new State();
    private Class<T> klazz;

    public StateManager(String path, Class<T> klazz) {
        this.tempStateFile = new File(path + ".tmp");
        this.tempStateFile.deleteOnExit();
        this.stateFile = new File(path);
        this.stateFile.getParentFile().mkdirs();
        boolean exists = this.stateFile.exists();
        long length = this.stateFile.length();
        if (this.stateFile.exists() && this.stateFile.length() > 0L) {
            ObjectMapper m = new ObjectMapper();
            JavaType type = m.getTypeFactory().constructParametricType(State.class, new Class[]{klazz});
            try {
                this.state = (State)m.readValue(this.stateFile, type);
                log.info("State file ( {} ) successfully read.", (Object)path);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            log.info("State file ( {} ) could not be read. Creating new state file. File exists: {}, file.length: {}", new Object[]{path, exists, length});
            this.state = new State();
        }
    }

    private void flush() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue(this.tempStateFile, this.state);
            log.debug("wrote {} to {}", this.state, (Object)this.tempStateFile.getAbsolutePath());
            this.stateFile.delete();
            FileUtils.moveFile((File)this.tempStateFile, (File)this.stateFile);
            log.debug("updated state:  moved  {} to {}", (Object)this.tempStateFile.getAbsolutePath(), (Object)this.stateFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("failed to save " + this.state + " to " + this.stateFile.getAbsolutePath(), e);
        }
    }

    public LinkedHashSet<T> getMorsels() {
        return this.state.getMorsels();
    }

    public void setMorsels(LinkedHashSet<T> morsels) {
        this.state.setMorsels(morsels);
        this.flush();
    }

    public Date getCurrentRunStartDate() {
        return this.state.getCurrentRunStartDate();
    }

    public void setCurrentRunStartDate(Date time) {
        this.state.setCurrentRunStartDate(time);
        this.flush();
    }

    public Date getNextRunStartDate() {
        return this.state.getNextRunStartDate();
    }

    public void setNextRunStartDate(Date time) {
        this.state.setNextRunStartDate(time);
        this.flush();
    }
}

