/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class StringQuery {
    private static final String PARAMETER_NAME_MISSING = "Name for parameter binding must not be null or empty! For named parameters you need to use @Param for query method parameters on Java versions < 8.";
    private final String query;
    private final List<ParameterBinding> bindings;
    private final String alias;

    public StringQuery(String query) {
        Assert.hasText(query, "Query must not be null or empty!");
        this.bindings = new ArrayList<ParameterBinding>();
        this.query = ParameterBindingParser.INSTANCE.parseParameterBindingsOfQueryIntoBindingsAndReturnCleanedQuery(query, this.bindings);
        this.alias = QueryUtils.detectAlias(query);
    }

    public boolean hasParameterBindings() {
        return !this.bindings.isEmpty();
    }

    List<ParameterBinding> getParameterBindings() {
        return this.bindings;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getAlias() {
        return this.alias;
    }

    public ParameterBinding getBindingFor(String name) {
        Assert.hasText(name, PARAMETER_NAME_MISSING);
        for (ParameterBinding binding : this.bindings) {
            if (!binding.hasName(name)) continue;
            return binding;
        }
        throw new IllegalArgumentException(String.format("No parameter binding found for name %s!", name));
    }

    public ParameterBinding getBindingFor(int position) {
        for (ParameterBinding binding : this.bindings) {
            if (!binding.hasPosition(position)) continue;
            return binding;
        }
        throw new IllegalArgumentException(String.format("No parameter binding found for position %s!", position));
    }

    static class LikeParameterBinding
    extends ParameterBinding {
        private static final List<Part.Type> SUPPORTED_TYPES = Arrays.asList(Part.Type.CONTAINING, Part.Type.STARTING_WITH, Part.Type.ENDING_WITH, Part.Type.LIKE);
        private final Part.Type type;

        public LikeParameterBinding(String name, Part.Type type) {
            this(name, type, null);
        }

        public LikeParameterBinding(String name, Part.Type type, String expression) {
            super(name, null, expression);
            Assert.hasText(name, "Name must not be null or empty!");
            Assert.notNull((Object)type, "Type must not be null!");
            Assert.isTrue(SUPPORTED_TYPES.contains((Object)type), String.format("Type must be one of %s!", StringUtils.collectionToCommaDelimitedString(SUPPORTED_TYPES)));
            this.type = type;
        }

        public LikeParameterBinding(int position, Part.Type type) {
            this(position, type, null);
        }

        public LikeParameterBinding(int position, Part.Type type, String expression) {
            super(null, position, expression);
            Assert.isTrue(position > 0, "Position must be greater than zero!");
            Assert.notNull((Object)type, "Type must not be null!");
            Assert.isTrue(SUPPORTED_TYPES.contains((Object)type), String.format("Type must be one of %s!", StringUtils.collectionToCommaDelimitedString(SUPPORTED_TYPES)));
            this.type = type;
        }

        public Part.Type getType() {
            return this.type;
        }

        @Override
        public Object prepare(Object value) {
            if (value == null) {
                return value;
            }
            switch (this.type) {
                case STARTING_WITH: {
                    return String.format("%s%%", value.toString());
                }
                case ENDING_WITH: {
                    return String.format("%%%s", value.toString());
                }
                case CONTAINING: {
                    return String.format("%%%s%%", value.toString());
                }
            }
            return value;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof LikeParameterBinding)) {
                return false;
            }
            LikeParameterBinding that = (LikeParameterBinding)obj;
            return super.equals(obj) && this.type.equals((Object)that.type);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result += ObjectUtils.nullSafeHashCode((Object)this.type);
        }

        @Override
        public String toString() {
            return String.format("LikeBinding [name: %s, position: %d, type: %s]", new Object[]{this.getName(), this.getPosition(), this.type});
        }

        private static Part.Type getLikeTypeFrom(String expression) {
            Assert.hasText(expression);
            if (expression.matches("%.*%")) {
                return Part.Type.CONTAINING;
            }
            if (expression.startsWith("%")) {
                return Part.Type.ENDING_WITH;
            }
            if (expression.endsWith("%")) {
                return Part.Type.STARTING_WITH;
            }
            return Part.Type.LIKE;
        }
    }

    static class InParameterBinding
    extends ParameterBinding {
        public InParameterBinding(String name, String expression) {
            super(name, null, expression);
        }

        public InParameterBinding(int position, String expression) {
            super(null, position, expression);
        }

        @Override
        public Object prepare(Object value) {
            if (!ObjectUtils.isArray(value)) {
                return value;
            }
            int length = Array.getLength(value);
            ArrayList<Object> result = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(value, i));
            }
            return result;
        }
    }

    static class ParameterBinding {
        private final String name;
        private final String expression;
        private final Integer position;

        public ParameterBinding(String name) {
            this(name, null, null);
        }

        public ParameterBinding(Integer position) {
            this(null, position, null);
        }

        ParameterBinding(String name, Integer position, String expression) {
            if (name == null) {
                Assert.notNull(position, "Position must not be null!");
            }
            if (position == null) {
                Assert.notNull(name, "Name must not be null!");
            }
            this.name = name;
            this.position = position;
            this.expression = expression;
        }

        public boolean hasName(String name) {
            return this.position == null && this.name != null && this.name.equals(name);
        }

        public boolean hasPosition(Integer position) {
            return position != null && this.name == null && position.equals(this.position);
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return this.position;
        }

        public boolean isExpression() {
            return this.expression != null;
        }

        public int hashCode() {
            int result = 17;
            result += ObjectUtils.nullSafeHashCode(this.name);
            result += ObjectUtils.nullSafeHashCode(this.position);
            return result += ObjectUtils.nullSafeHashCode(this.expression);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterBinding)) {
                return false;
            }
            ParameterBinding that = (ParameterBinding)obj;
            return ObjectUtils.nullSafeEquals(this.name, that.name) && ObjectUtils.nullSafeEquals(this.position, that.position) && ObjectUtils.nullSafeEquals(this.expression, that.expression);
        }

        public String toString() {
            return String.format("ParameterBinding [name: %s, position: %d, expression: %s]", this.getName(), this.getPosition(), this.getExpression());
        }

        public Object prepare(Object valueToBind) {
            return valueToBind;
        }

        public String getExpression() {
            return this.expression;
        }
    }

    public static enum ParameterBindingParser {
        INSTANCE;

        static final String EXPRESSION_PARAMETER_PREFIX = "__$synthetic$__";
        private static final Pattern PARAMETER_BINDING_BY_INDEX;
        private static final Pattern PARAMETER_BINDING_PATTERN;
        private static final String MESSAGE = "Already found parameter binding with same index / parameter name but differing binding type! Already have: %s, found %s! If you bind a parameter multiple times make sure they use the same binding.";

        private final String parseParameterBindingsOfQueryIntoBindingsAndReturnCleanedQuery(String query, List<ParameterBinding> bindings) {
            int expressionParameterIndex;
            boolean parametersShouldBeAccessedByIndex;
            String result = query;
            Matcher matcher = PARAMETER_BINDING_PATTERN.matcher(query);
            int greatestParameterIndex = this.tryFindGreatestParameterIndexIn(query);
            boolean bl = parametersShouldBeAccessedByIndex = greatestParameterIndex != -1;
            if (!parametersShouldBeAccessedByIndex && query.contains("?#{")) {
                parametersShouldBeAccessedByIndex = true;
                greatestParameterIndex = 0;
            }
            int n = expressionParameterIndex = parametersShouldBeAccessedByIndex ? greatestParameterIndex : 0;
            while (matcher.find()) {
                String parameterIndexString = matcher.group(4);
                String parameterName = parameterIndexString != null ? null : matcher.group(6);
                Integer parameterIndex = parameterIndexString == null ? null : Integer.valueOf(parameterIndexString);
                String typeSource = matcher.group(1);
                String expression = null;
                String replacement = null;
                if (parameterName == null && parameterIndex == null) {
                    ++expressionParameterIndex;
                    if (parametersShouldBeAccessedByIndex) {
                        parameterIndex = expressionParameterIndex;
                        replacement = "?" + parameterIndex;
                    } else {
                        parameterName = EXPRESSION_PARAMETER_PREFIX + expressionParameterIndex;
                        replacement = ":" + parameterName;
                    }
                    expression = matcher.group(9);
                }
                switch (ParameterBindingType.of(typeSource)) {
                    case LIKE: {
                        Part.Type likeType = LikeParameterBinding.getLikeTypeFrom(matcher.group(2));
                        String string = replacement = replacement != null ? replacement : matcher.group(3);
                        if (parameterIndex != null) {
                            ParameterBindingParser.checkAndRegister(new LikeParameterBinding(parameterIndex, likeType, expression), bindings);
                            break;
                        }
                        ParameterBindingParser.checkAndRegister(new LikeParameterBinding(parameterName, likeType, expression), bindings);
                        replacement = expression != null ? ":" + parameterName : matcher.group(5);
                        break;
                    }
                    case IN: {
                        if (parameterIndex != null) {
                            ParameterBindingParser.checkAndRegister(new InParameterBinding(parameterIndex, expression), bindings);
                        } else {
                            ParameterBindingParser.checkAndRegister(new InParameterBinding(parameterName, expression), bindings);
                        }
                        result = query;
                        break;
                    }
                    default: {
                        bindings.add(parameterIndex != null ? new ParameterBinding(null, parameterIndex, expression) : new ParameterBinding(parameterName, null, expression));
                    }
                }
                if (replacement == null) continue;
                result = StringUtils.replace(result, matcher.group(2), replacement);
            }
            return result;
        }

        private int tryFindGreatestParameterIndexIn(String query) {
            Matcher parameterIndexMatcher = PARAMETER_BINDING_BY_INDEX.matcher(query);
            int greatestParameterIndex = -1;
            while (parameterIndexMatcher.find()) {
                String parameterIndexString = parameterIndexMatcher.group(1);
                greatestParameterIndex = Math.max(greatestParameterIndex, Integer.parseInt(parameterIndexString));
            }
            return greatestParameterIndex;
        }

        private static void checkAndRegister(ParameterBinding binding, List<ParameterBinding> bindings) {
            for (ParameterBinding existing : bindings) {
                if (!existing.hasName(binding.getName()) && !existing.hasPosition(binding.getPosition())) continue;
                Assert.isTrue(existing.equals(binding), String.format(MESSAGE, existing, binding));
            }
            if (!bindings.contains(binding)) {
                bindings.add(binding);
            }
        }

        static {
            PARAMETER_BINDING_BY_INDEX = Pattern.compile("\\?(\\d+)");
            ArrayList<String> keywords = new ArrayList<String>();
            for (ParameterBindingType type : ParameterBindingType.values()) {
                if (type.getKeyword() == null) continue;
                keywords.add(type.getKeyword());
            }
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            builder.append(StringUtils.collectionToDelimitedString(keywords, "|"));
            builder.append(")?");
            builder.append("(?: )?");
            builder.append("\\(?");
            builder.append("(");
            builder.append("%?(\\?(\\d+))%?");
            builder.append("|");
            builder.append("%?(:([\\p{L}\\w]+))%?");
            builder.append("|");
            builder.append("%?((:|\\?)#\\{([^}]+)\\})%?");
            builder.append(")");
            builder.append("\\)?");
            PARAMETER_BINDING_PATTERN = Pattern.compile(builder.toString(), 2);
        }

        private static enum ParameterBindingType {
            LIKE("like "),
            IN("in "),
            AS_IS(null);

            private final String keyword;

            private ParameterBindingType(String keyword) {
                this.keyword = keyword;
            }

            public String getKeyword() {
                return this.keyword;
            }

            static ParameterBindingType of(String typeSource) {
                if (!StringUtils.hasText(typeSource)) {
                    return AS_IS;
                }
                for (ParameterBindingType type : ParameterBindingType.values()) {
                    if (!type.name().equalsIgnoreCase(typeSource.trim())) continue;
                    return type;
                }
                throw new IllegalArgumentException(String.format("Unsupported parameter binding type %s!", typeSource));
            }
        }
    }
}

