/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

enum CrudMethodMetadataPostProcessor implements RepositoryProxyPostProcessor
{
    INSTANCE;


    @Override
    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice(ExposeInvocationInterceptor.INSTANCE);
        factory.addAdvice(CrudMethodMetadataPopulatingMethodIntercceptor.INSTANCE);
    }

    public CrudMethodMetadata getLockMetadataProvider() {
        ProxyFactory factory = new ProxyFactory();
        factory.addInterface(CrudMethodMetadata.class);
        factory.setTargetSource(new ThreadBoundTargetSource());
        return (CrudMethodMetadata)factory.getProxy();
    }

    private static class ThreadBoundTargetSource
    extends AbstractLazyCreationTargetSource {
        private ThreadBoundTargetSource() {
        }

        @Override
        protected Object createObject() throws Exception {
            MethodInvocation invocation = ExposeInvocationInterceptor.currentInvocation();
            return TransactionSynchronizationManager.getResource(invocation.getMethod());
        }
    }

    private static class DefaultCrudMethodMetadata
    implements CrudMethodMetadata {
        private final LockModeType lockModeType;
        private final Map<String, Object> queryHints;

        public DefaultCrudMethodMetadata(Method method) {
            Assert.notNull(method, "Method must not be null!");
            this.lockModeType = DefaultCrudMethodMetadata.findLockModeType(method);
            this.queryHints = DefaultCrudMethodMetadata.findQueryHints(method);
        }

        private static final LockModeType findLockModeType(Method method) {
            Lock annotation = AnnotationUtils.findAnnotation(method, Lock.class);
            return annotation == null ? null : (LockModeType)((Object)AnnotationUtils.getValue(annotation));
        }

        private static final Map<String, Object> findQueryHints(Method method) {
            QueryHint queryHintAnnotation;
            HashMap<String, String> queryHints = new HashMap<String, String>();
            QueryHints queryHintsAnnotation = AnnotationUtils.findAnnotation(method, QueryHints.class);
            if (queryHintsAnnotation != null) {
                for (QueryHint hint : queryHintsAnnotation.value()) {
                    queryHints.put(hint.name(), hint.value());
                }
            }
            if ((queryHintAnnotation = AnnotationUtils.findAnnotation(method, QueryHint.class)) != null) {
                queryHints.put(queryHintAnnotation.name(), queryHintAnnotation.value());
            }
            return Collections.unmodifiableMap(queryHints);
        }

        @Override
        public LockModeType getLockModeType() {
            return this.lockModeType;
        }

        @Override
        public Map<String, Object> getQueryHints() {
            return this.queryHints;
        }
    }

    static enum CrudMethodMetadataPopulatingMethodIntercceptor implements MethodInterceptor
    {
        INSTANCE;

        private final Map<Method, CrudMethodMetadata> metadataCache = new HashMap<Method, CrudMethodMetadata>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object metadata = TransactionSynchronizationManager.getResource(method);
            if (metadata != null) {
                return invocation.proceed();
            }
            CrudMethodMetadata methodMetadata = this.metadataCache.get(method);
            if (methodMetadata == null) {
                methodMetadata = new DefaultCrudMethodMetadata(method);
                this.metadataCache.put(method, methodMetadata);
            }
            TransactionSynchronizationManager.bindResource(method, methodMetadata);
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                TransactionSynchronizationManager.unbindResource(method);
            }
        }
    }
}

