/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.jpa.domain.support.AuditingBeanFactoryPostProcessor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class JpaAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    private static final String BEAN_CONFIGURER_ASPECT_CLASS_NAME = "org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect";

    JpaAuditingRegistrar() {
    }

    @Override
    protected Class<? extends Annotation> getAnnotation() {
        return EnableJpaAuditing.class;
    }

    @Override
    protected String getAuditingHandlerBeanName() {
        return "jpaAuditingHandler";
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull(annotationMetadata, "AnnotationMetadata must not be null!");
        Assert.notNull(registry, "BeanDefinitionRegistry must not be null!");
        this.registerBeanConfigurerAspectIfNecessary(registry);
        super.registerBeanDefinitions(annotationMetadata, registry);
        this.registerInfrastructureBeanWithId(BeanDefinitionBuilder.rootBeanDefinition(AuditingBeanFactoryPostProcessor.class).getRawBeanDefinition(), AuditingBeanFactoryPostProcessor.class.getName(), registry);
    }

    @Override
    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(AuditingEntityListener.class);
        builder.addPropertyValue("auditingHandler", ParsingUtils.getObjectFactoryBeanDefinition(this.getAuditingHandlerBeanName(), null));
        this.registerInfrastructureBeanWithId(builder.getRawBeanDefinition(), AuditingEntityListener.class.getName(), registry);
    }

    private void registerBeanConfigurerAspectIfNecessary(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(BEAN_CONFIGURER_ASPECT_CLASS_NAME)) {
            return;
        }
        if (!ClassUtils.isPresent(BEAN_CONFIGURER_ASPECT_CLASS_NAME, this.getClass().getClassLoader())) {
            throw new BeanDefinitionStoreException("org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect not found. \nCould not configure Spring Data JPA auditing-feature because spring-aspects.jar is not on the classpath!\nIf you want to use auditing please add spring-aspects.jar to the classpath.");
        }
        RootBeanDefinition def = new RootBeanDefinition();
        def.setBeanClassName(BEAN_CONFIGURER_ASPECT_CLASS_NAME);
        def.setFactoryMethodName("aspectOf");
        def.setRole(2);
        registry.registerBeanDefinition("org.springframework.context.config.internalBeanConfigurerAspect", new BeanComponentDefinition(def, "org.springframework.context.config.internalBeanConfigurerAspect").getBeanDefinition());
    }
}

