/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.criteria.CommonAbstractCriteria;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.CriteriaSubqueryImpl;
import org.hibernate.jpa.criteria.Renderable;
import org.hibernate.jpa.criteria.ValueHandlerFactory;
import org.hibernate.jpa.criteria.compile.CompilableCriteria;
import org.hibernate.jpa.criteria.compile.CriteriaInterpretation;
import org.hibernate.jpa.criteria.compile.ImplicitParameterBinding;
import org.hibernate.jpa.criteria.compile.InterpretedParameterMetadata;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.path.RootImpl;
import org.hibernate.jpa.internal.QueryImpl;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;

public abstract class AbstractManipulationCriteriaQuery<T>
implements CompilableCriteria,
CommonAbstractCriteria {
    private final CriteriaBuilderImpl criteriaBuilder;
    private RootImpl<T> root;
    private Predicate restriction;
    private List<Subquery<?>> subQueries;

    protected AbstractManipulationCriteriaQuery(CriteriaBuilderImpl criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
    }

    protected CriteriaBuilderImpl criteriaBuilder() {
        return this.criteriaBuilder;
    }

    public Root from(Class<T> entityClass) {
        EntityType<T> entityType = this.criteriaBuilder.getEntityManagerFactory().getMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return this.from(entityType);
    }

    public Root<T> from(EntityType<T> entityType) {
        this.root = new RootImpl<T>(this.criteriaBuilder, entityType, false);
        return this.root;
    }

    public Root<T> getRoot() {
        return this.root;
    }

    protected void setRestriction(Expression<Boolean> restriction) {
        this.restriction = this.criteriaBuilder.wrap(restriction);
    }

    public void setRestriction(Predicate ... restrictions) {
        this.restriction = this.criteriaBuilder.and(restrictions);
    }

    @Override
    public Predicate getRestriction() {
        return this.restriction;
    }

    @Override
    public <U> Subquery<U> subquery(Class<U> type) {
        return new CriteriaSubqueryImpl<U>(this.criteriaBuilder(), type, this);
    }

    @Override
    public void validate() {
        if (this.root == null) {
            throw new IllegalStateException("UPDATE/DELETE criteria must name root entity");
        }
    }

    @Override
    public CriteriaInterpretation interpret(RenderingContext renderingContext) {
        final String jpaqlString = this.renderQuery(renderingContext);
        return new CriteriaInterpretation(){

            @Override
            public Query buildCompiledQuery(HibernateEntityManagerImplementor entityManager, InterpretedParameterMetadata interpretedParameterMetadata) {
                final Map<String, Class> implicitParameterTypes = this.extractTypeMap(interpretedParameterMetadata.implicitParameterBindings());
                QueryImpl jpaqlQuery = entityManager.createQuery(jpaqlString, null, null, new HibernateEntityManagerImplementor.QueryOptions(){

                    @Override
                    public List<ValueHandlerFactory.ValueHandler> getValueHandlers() {
                        return null;
                    }

                    @Override
                    public Map<String, Class> getNamedParameterExplicitTypes() {
                        return implicitParameterTypes;
                    }

                    @Override
                    public HibernateEntityManagerImplementor.QueryOptions.ResultMetadataValidator getResultMetadataValidator() {
                        return null;
                    }
                });
                for (ImplicitParameterBinding implicitParameterBinding : interpretedParameterMetadata.implicitParameterBindings()) {
                    implicitParameterBinding.bind(jpaqlQuery);
                }
                return jpaqlQuery;
            }

            private Map<String, Class> extractTypeMap(List<ImplicitParameterBinding> implicitParameterBindings) {
                HashMap<String, Class> map = new HashMap<String, Class>();
                for (ImplicitParameterBinding implicitParameter : implicitParameterBindings) {
                    map.put(implicitParameter.getParameterName(), implicitParameter.getJavaType());
                }
                return map;
            }
        };
    }

    protected abstract String renderQuery(RenderingContext var1);

    protected void renderRoot(StringBuilder jpaql, RenderingContext renderingContext) {
        jpaql.append(this.root.renderTableExpression(renderingContext));
    }

    protected void renderRestrictions(StringBuilder jpaql, RenderingContext renderingContext) {
        if (this.getRestriction() != null) {
            jpaql.append(" where ").append(((Renderable)((Object)this.getRestriction())).render(renderingContext));
        }
    }
}

