/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.Arrays;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactorySupport;
import org.springframework.util.Assert;

public class MappingContextIsNewStrategyFactory
extends IsNewStrategyFactorySupport {
    private final PersistentEntities context;

    @Deprecated
    public MappingContextIsNewStrategyFactory(MappingContext<? extends PersistentEntity<?, ?>, ?> context) {
        this(new PersistentEntities(Arrays.asList(context)));
    }

    public MappingContextIsNewStrategyFactory(PersistentEntities entities) {
        Assert.notNull(entities, "PersistentEntities must not be null!");
        this.context = entities;
    }

    @Override
    protected IsNewStrategy doGetIsNewStrategy(Class<?> type) {
        PersistentEntity<?, ?> entity = this.context.getPersistentEntity(type);
        if (entity == null) {
            return null;
        }
        if (entity.hasVersionProperty()) {
            return new PropertyIsNullOrZeroNumberIsNewStrategy((PersistentProperty<?>)entity.getVersionProperty());
        }
        if (entity.hasIdProperty()) {
            return new PropertyIsNullIsNewStrategy((PersistentProperty<?>)entity.getIdProperty());
        }
        throw new MappingException(String.format("Cannot determine IsNewStrategy for type %s!", type));
    }

    static class PropertyIsNullOrZeroNumberIsNewStrategy
    extends PersistentPropertyInspectingIsNewStrategy {
        public PropertyIsNullOrZeroNumberIsNewStrategy(PersistentProperty<?> property) {
            super(property);
        }

        @Override
        protected boolean decideIsNew(Object property) {
            if (property == null) {
                return true;
            }
            if (!(property instanceof Number)) {
                return false;
            }
            return ((Number)property).longValue() == 0L;
        }
    }

    static class PropertyIsNullIsNewStrategy
    extends PersistentPropertyInspectingIsNewStrategy {
        public PropertyIsNullIsNewStrategy(PersistentProperty<?> property) {
            super(property);
        }

        @Override
        protected boolean decideIsNew(Object property) {
            return property == null;
        }
    }

    static abstract class PersistentPropertyInspectingIsNewStrategy
    implements IsNewStrategy {
        private final PersistentProperty<?> property;

        public PersistentPropertyInspectingIsNewStrategy(PersistentProperty<?> property) {
            Assert.notNull(property, "PersistentProperty must not be null!");
            this.property = property;
        }

        @Override
        public boolean isNew(Object entity) {
            PersistentPropertyAccessor accessor = this.property.getOwner().getPropertyAccessor(entity);
            Object propertyValue = accessor.getProperty(this.property);
            return this.decideIsNew(propertyValue);
        }

        protected abstract boolean decideIsNew(Object var1);
    }
}

