/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.init;

import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.data.repository.init.RepositoryPopulator;
import org.springframework.data.repository.init.ResourceReader;
import org.springframework.data.repository.init.ResourceReaderRepositoryPopulator;
import org.springframework.data.repository.support.Repositories;
import org.springframework.util.Assert;

public abstract class AbstractRepositoryPopulatorFactoryBean
extends AbstractFactoryBean<ResourceReaderRepositoryPopulator>
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private Resource[] resources;
    private RepositoryPopulator populator;
    private ApplicationContext context;

    public void setResources(Resource[] resources) {
        Assert.notNull(resources, "Resources must not be null!");
        this.resources = (Resource[])resources.clone();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Override
    public Class<?> getObjectType() {
        return ResourceReaderRepositoryPopulator.class;
    }

    @Override
    protected ResourceReaderRepositoryPopulator createInstance() {
        ResourceReaderRepositoryPopulator initializer = new ResourceReaderRepositoryPopulator(this.getResourceReader());
        initializer.setResources(this.resources);
        initializer.setApplicationEventPublisher(this.context);
        this.populator = initializer;
        return initializer;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.context)) {
            Repositories repositories = new Repositories(event.getApplicationContext());
            this.populator.populate(repositories);
        }
    }

    protected abstract ResourceReader getResourceReader();
}

