/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleemail.model.TestRenderTemplateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TestRenderTemplateRequestMarshaller
implements Marshaller<Request<TestRenderTemplateRequest>, TestRenderTemplateRequest> {
    @Override
    public Request<TestRenderTemplateRequest> marshall(TestRenderTemplateRequest testRenderTemplateRequest) {
        if (testRenderTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TestRenderTemplateRequest> request = new DefaultRequest<TestRenderTemplateRequest>(testRenderTemplateRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "TestRenderTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (testRenderTemplateRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString(testRenderTemplateRequest.getTemplateName()));
        }
        if (testRenderTemplateRequest.getTemplateData() != null) {
            request.addParameter("TemplateData", StringUtils.fromString(testRenderTemplateRequest.getTemplateData()));
        }
        return request;
    }
}

