/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesResult;
import com.amazonaws.services.simpleemail.waiters.GetIdentityVerificationAttributesFunction;
import com.amazonaws.services.simpleemail.waiters.IdentityExists;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonSimpleEmailServiceWaiters {
    private final AmazonSimpleEmailService client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonSimpleEmailServiceWaiters");

    @SdkInternalApi
    public AmazonSimpleEmailServiceWaiters(AmazonSimpleEmailService client) {
        this.client = client;
    }

    public Waiter<GetIdentityVerificationAttributesRequest> identityExists() {
        return new WaiterBuilder<GetIdentityVerificationAttributesRequest, GetIdentityVerificationAttributesResult>().withSdkFunction(new GetIdentityVerificationAttributesFunction(this.client)).withAcceptors(new IdentityExists.IsSuccessMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

