/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.manifest.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.model.Credential;
import org.duracloud.mill.manifest.builder.ManifestBuilder;
import org.duracloud.mill.util.CommonCommandLineOptions;
import org.duracloud.mill.util.DriverSupport;
import org.duracloud.mill.util.PropertyDefinition;
import org.duracloud.mill.util.PropertyDefinitionListBuilder;
import org.duracloud.mill.util.PropertyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ManifestBuilderDriver
extends DriverSupport {
    private static Logger log = LoggerFactory.getLogger(ManifestBuilderDriver.class);

    public ManifestBuilderDriver() {
        super(new ManifestBuilderOptions());
    }

    public static void main(String[] args) {
        new ManifestBuilderDriver().execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl(CommandLine cmd) {
        try {
            String stores;
            String spaces;
            List<PropertyDefinition> defintions = new PropertyDefinitionListBuilder().addMillDb().build();
            PropertyVerifier verifier = new PropertyVerifier(defintions);
            verifier.verify(System.getProperties());
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext("org.duracloud.mill.db", "org.duracloud.mill.manifest.builder");
            log.info("context initialized");
            boolean dryRun = cmd.hasOption("d");
            boolean clean = cmd.hasOption("C");
            String host = cmd.getOptionValue("host");
            String port = cmd.getOptionValue("port", "443");
            String username = cmd.getOptionValue("u");
            String password = cmd.getOptionValue("p");
            LinkedList<String> spaceList = new LinkedList();
            if (cmd.hasOption("s") && !StringUtils.isEmpty(spaces = cmd.getOptionValue("s", ""))) {
                spaceList = Arrays.asList(spaces.split("[,]"));
            }
            List<Object> storeList = new LinkedList();
            if (cmd.hasOption("t") && !StringUtils.isEmpty(stores = cmd.getOptionValue("t", ""))) {
                storeList = Arrays.asList(stores.split("[,]"));
            }
            int threads = 0;
            if (cmd.hasOption("T")) {
                threads = Integer.parseInt(cmd.getOptionValue("T", "10"));
            }
            String account = host.split("[.]")[0];
            ContentStoreManagerImpl storeManager = new ContentStoreManagerImpl(host, port);
            storeManager.login(new Credential(username, password));
            Map<String, ContentStore> contentStoreMap = storeManager.getContentStores();
            LinkedList<ContentStore> contentStores = new LinkedList<ContentStore>();
            for (String storeId : contentStoreMap.keySet()) {
                if (!storeList.isEmpty() && !storeList.contains(storeId)) continue;
                ContentStore contentStore = contentStoreMap.get(storeId);
                contentStores.add(contentStore);
            }
            ManifestBuilder builder = context.getBean(ManifestBuilder.class);
            builder.init(account, contentStores, spaceList, clean, dryRun, threads);
            builder.execute();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        finally {
            log.info("exiting...");
        }
    }

    private static class ManifestBuilderOptions
    extends CommonCommandLineOptions {
        public ManifestBuilderOptions() {
            this.addOption("u", "username", true, "DuraCloud username");
            this.addOption("p", "password", true, "DuraCloud password");
            this.addOption("h", "host", true, "DuraCloud host");
            this.addOption("r", "port", true, "DuraCloud port: 443 by default", false);
            this.addOption("s", "space-list", true, "A list of spaces to be included", false);
            this.addOption("t", "store-list", true, "A list of storage providers to be included", false);
            this.addOption("d", "dry-run", false, "Do not modify the manifest - only show what updates will be made.", false);
            this.addOption("C", "clean", false, "Indicates that the manifest database should be cleared before performing updates.", false);
            this.addOption("T", "threads", true, "The number of threads to be used. Default: 10", false);
        }

        @Override
        public Options addOption(String opt, String longOpt, boolean hasArg, String description) {
            return this.addOption(opt, longOpt, hasArg, description, true);
        }

        public Options addOption(String opt, String longOpt, boolean hasArg, String description, boolean required) {
            Option option = new Option(opt, longOpt, hasArg, description);
            option.setRequired(required);
            return super.addOption(option);
        }
    }
}

