/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SimpleTypeInformationMapper
implements TypeInformationMapper {
    private final Map<String, CachedTypeInformation> CACHE = new ConcurrentHashMap<String, CachedTypeInformation>();

    public ClassTypeInformation<?> resolveTypeFrom(Object alias) {
        if (!(alias instanceof String)) {
            return null;
        }
        String value = (String)alias;
        if (!StringUtils.hasText(value)) {
            return null;
        }
        CachedTypeInformation cachedValue = this.CACHE.get(value);
        if (cachedValue != null) {
            return cachedValue.getType();
        }
        try {
            return this.cacheAndReturn(value, ClassTypeInformation.from(ClassUtils.forName(value, null)));
        }
        catch (ClassNotFoundException e) {
            return this.cacheAndReturn(value, null);
        }
    }

    private ClassTypeInformation<?> cacheAndReturn(String value, ClassTypeInformation<?> type) {
        this.CACHE.put(value, CachedTypeInformation.of(type));
        return type;
    }

    @Override
    public String createAliasFor(TypeInformation<?> type) {
        return type.getType().getName();
    }

    static final class CachedTypeInformation {
        private final ClassTypeInformation<?> type;

        @Generated
        private CachedTypeInformation(ClassTypeInformation<?> type) {
            this.type = type;
        }

        @Generated
        public static CachedTypeInformation of(ClassTypeInformation<?> type) {
            return new CachedTypeInformation(type);
        }

        @Generated
        public ClassTypeInformation<?> getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedTypeInformation)) {
                return false;
            }
            CachedTypeInformation other = (CachedTypeInformation)o;
            ClassTypeInformation<?> this$type = this.getType();
            ClassTypeInformation<?> other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClassTypeInformation<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SimpleTypeInformationMapper.CachedTypeInformation(type=" + this.getType() + ")";
        }
    }
}

