/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.spring;

import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.WorkflowContext;
import com.amazonaws.services.simpleworkflow.flow.WorkflowExecutionLocal;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericActivityClient;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.worker.CurrentDecisionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowScope
implements Scope,
ApplicationContextAware {
    public static final String NAME = "workflow";
    private DecisionContextProvider contextProvider = new DecisionContextProviderImpl();
    private static WorkflowExecutionLocal<Map<String, Object>> objects = new WorkflowExecutionLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static WorkflowExecutionLocal<List<Runnable>> destructionCallbacks = new WorkflowExecutionLocal<List<Runnable>>(){

        @Override
        protected List<Runnable> initialValue() {
            return new ArrayList<Runnable>();
        }
    };

    public static void setDecisionContext(DecisionContext context) {
        CurrentDecisionContext.set(context);
        destructionCallbacks.get().clear();
        WorkflowScope.set("genericActivityClient", context.getActivityClient());
        WorkflowScope.set("genericWorkflowClient", context.getWorkflowClient());
        WorkflowScope.set("workflowClock", context.getWorkflowClock());
        WorkflowScope.set("workflowContext", context.getWorkflowContext());
        WorkflowScope.set("decisionContext", context);
    }

    public static void removeDecisionContext() {
        for (Runnable callback : destructionCallbacks.get()) {
            callback.run();
        }
        CurrentDecisionContext.unset();
    }

    @Override
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Map<String, Object> map = objects.get();
        Object result = map.get(name);
        if (result == null) {
            result = objectFactory.getObject();
            map.put(name, result);
        }
        return result;
    }

    private static void set(String name, Object bean) {
        Map<String, Object> map = objects.get();
        map.put(name, bean);
    }

    @Override
    public String getConversationId() {
        return this.contextProvider.getDecisionContext().getWorkflowContext().getWorkflowExecution().getRunId();
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback) {
        destructionCallbacks.get().add(callback);
    }

    @Override
    public Object remove(String name) {
        Map<String, Object> map = objects.get();
        return map.remove(name);
    }

    @Override
    public Object resolveContextualObject(String name) {
        return null;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        if (!(autowireCapableBeanFactory instanceof DefaultListableBeanFactory)) {
            throw new IllegalArgumentException("The implementation returned from applicationContext.getAutowireCapableBeanFactory() doesn't implement DefaultListableBeanFactory");
        }
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)autowireCapableBeanFactory;
        this.registerBean(factory, "genericActivityClient", GenericActivityClient.class);
        this.registerBean(factory, "genericWorkflowClient", GenericWorkflowClient.class);
        this.registerBean(factory, "workflowClock", WorkflowClock.class);
        this.registerBean(factory, "workflowContext", WorkflowContext.class);
        this.registerBean(factory, "decisionContext", DecisionContext.class);
    }

    private void registerBean(DefaultListableBeanFactory factory, String beanName, Class<?> beanClass) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        builder.setScope(NAME);
        factory.registerBeanDefinition(beanName, builder.getBeanDefinition());
    }
}

