/*
 * Decompiled with CFR 0.152.
 */
package com.jamesmurty.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.iharder.base64.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLBuilder {
    private Document xmlDocument = null;
    private Element xmlElement = null;

    protected XMLBuilder(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.xmlElement = xmlDocument.getDocumentElement();
    }

    protected XMLBuilder(Element myElement, Element parentElement) {
        this.xmlElement = myElement;
        this.xmlDocument = myElement.getOwnerDocument();
        if (parentElement != null) {
            parentElement.appendChild(myElement);
        }
    }

    public static XMLBuilder create(String name) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement(name);
        document.appendChild(rootElement);
        return new XMLBuilder(document);
    }

    public static XMLBuilder parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(inputSource);
        return new XMLBuilder(document);
    }

    public XMLBuilder importXMLBuilder(XMLBuilder builder) {
        this.assertCurrentElementHasNoTextNodes();
        Node importedNode = this.getDocument().importNode(builder.root().getElement(), true);
        this.xmlElement.appendChild(importedNode);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XMLBuilder) {
            XMLBuilder other = (XMLBuilder)obj;
            return this.xmlDocument.equals(other.getDocument()) && this.xmlElement.equals(other.getElement());
        }
        return false;
    }

    public Element getElement() {
        return this.xmlElement;
    }

    public XMLBuilder root() {
        return new XMLBuilder(this.getDocument());
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    public XMLBuilder xpathFind(String xpath) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPathExpression xpathExp = xpathFactory.newXPath().compile(xpath);
        Node foundNode = (Node)xpathExp.evaluate(this.xmlElement, XPathConstants.NODE);
        if (foundNode == null || foundNode.getNodeType() != 1) {
            throw new XPathExpressionException("XPath expression \"" + xpath + "\" does not resolve to an Element in context " + this.xmlElement + ": " + foundNode);
        }
        return new XMLBuilder((Element)foundNode, null);
    }

    public XMLBuilder element(String name) {
        this.assertCurrentElementHasNoTextNodes();
        return new XMLBuilder(this.getDocument().createElement(name), this.xmlElement);
    }

    public XMLBuilder elem(String name) {
        return this.element(name);
    }

    public XMLBuilder e(String name) {
        return this.element(name);
    }

    public XMLBuilder attribute(String name, String value) {
        this.xmlElement.setAttribute(name, value);
        return this;
    }

    public XMLBuilder attr(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder a(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder text(String value) {
        this.xmlElement.appendChild(this.getDocument().createTextNode(value));
        return this;
    }

    public XMLBuilder t(String value) {
        return this.text(value);
    }

    public XMLBuilder cdata(byte[] data) {
        this.xmlElement.appendChild(this.getDocument().createCDATASection(Base64.encodeBytes(data, 8)));
        return this;
    }

    public XMLBuilder data(byte[] data) {
        return this.cdata(data);
    }

    public XMLBuilder d(byte[] data) {
        return this.cdata(data);
    }

    public XMLBuilder comment(String comment) {
        this.xmlElement.appendChild(this.getDocument().createComment(comment));
        return this;
    }

    public XMLBuilder cmnt(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder c(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder instruction(String target, String data) {
        this.xmlElement.appendChild(this.getDocument().createProcessingInstruction(target, data));
        return this;
    }

    public XMLBuilder inst(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder i(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder reference(String name) {
        this.xmlElement.appendChild(this.getDocument().createEntityReference(name));
        return this;
    }

    public XMLBuilder ref(String name) {
        return this.reference(name);
    }

    public XMLBuilder r(String name) {
        return this.reference(name);
    }

    public XMLBuilder up(int steps) {
        Node currNode = this.xmlElement;
        for (int stepCount = 0; currNode.getParentNode() != null && stepCount < steps; ++stepCount) {
            currNode = currNode.getParentNode();
        }
        if (currNode instanceof Document) {
            return new XMLBuilder((Document)currNode);
        }
        return new XMLBuilder((Element)currNode, null);
    }

    public XMLBuilder up() {
        return this.up(1);
    }

    protected void assertCurrentElementHasNoTextNodes() {
        Node textNode = null;
        NodeList childNodes = this.xmlElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (3 != childNodes.item(i).getNodeType()) continue;
            textNode = childNodes.item(i);
            break;
        }
        if (textNode != null) {
            throw new IllegalStateException("Cannot add sub-element to element <" + this.xmlElement.getNodeName() + "> that already contains the Text node: " + textNode);
        }
    }

    public void toWriter(Writer writer, Properties outputProperties) throws TransformerException {
        StreamResult streamResult = new StreamResult(writer);
        DOMSource domSource = new DOMSource(this.getDocument());
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        if (outputProperties != null) {
            Iterator iter = ((Hashtable)outputProperties).entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                serializer.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        serializer.transform(domSource, streamResult);
    }

    public String asString(Properties outputProperties) throws TransformerException {
        StringWriter writer = new StringWriter();
        this.toWriter(writer, outputProperties);
        return writer.toString();
    }

    public String asString() throws TransformerException {
        Properties outputProperties = new Properties();
        ((Hashtable)outputProperties).put("omit-xml-declaration", "yes");
        return this.asString(outputProperties);
    }
}

