/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.manifest.cleaner;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.duracloud.mill.db.util.MillJpaPropertiesVerifier;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.util.CommonCommandLineOptions;
import org.duracloud.mill.util.DriverSupport;
import org.duracloud.mill.util.PropertyDefinition;
import org.duracloud.mill.util.PropertyDefinitionListBuilder;
import org.duracloud.mill.util.PropertyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ManifestCleanerDriver
extends DriverSupport {
    private static Logger log = LoggerFactory.getLogger(ManifestCleanerDriver.class);

    public ManifestCleanerDriver() {
        super(new CommonCommandLineOptions());
    }

    public static void main(String[] args) {
        new ManifestCleanerDriver().execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl(CommandLine cmd) {
        try {
            List<PropertyDefinition> defintions = new PropertyDefinitionListBuilder().addMillDb().addManifestExpirationDate().build();
            PropertyVerifier verifier = new PropertyVerifier(defintions);
            verifier.verify(System.getProperties());
            String time = System.getProperty("manifest.expiration-time");
            Date expirationDate = this.parseExpirationDate(time);
            new MillJpaPropertiesVerifier().verify();
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext("org.duracloud.mill");
            log.info("spring context initialized.");
            ManifestStore store = context.getBean(ManifestStore.class);
            Long deleted = store.purgeDeletedItemsBefore(expirationDate);
            log.info("Deleted {} items that were flagged as deleted before {}", (Object)deleted, (Object)expirationDate);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        finally {
            log.info("exiting...");
        }
    }

    private Date parseExpirationDate(String time) throws ParseException {
        Calendar c = Calendar.getInstance();
        String pattern = "([0-9]+)([smhd])";
        if (!time.matches(pattern)) {
            throw new ParseException(time + " is not a valid time value.");
        }
        int amount = Integer.parseInt(time.replaceAll(pattern, "$1"));
        String units = time.replaceAll(pattern, "$2");
        int field = 13;
        if (units.equals("m")) {
            field = 12;
        } else if (units.equals("h")) {
            field = 10;
        } else if (units.equals("d")) {
            field = 5;
        } else {
            throw new RuntimeException("unit " + units + " not recognized.");
        }
        c.add(field, -1 * amount);
        return c.getTime();
    }
}

