/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import java.sql.Driver;
import org.springframework.jdbc.datasource.embedded.AbstractEmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class H2EmbeddedDatabaseConfigurer
extends AbstractEmbeddedDatabaseConfigurer {
    private static H2EmbeddedDatabaseConfigurer INSTANCE;
    private final Class<? extends Driver> driverClass;

    public static synchronized H2EmbeddedDatabaseConfigurer getInstance() throws ClassNotFoundException {
        if (INSTANCE == null) {
            INSTANCE = new H2EmbeddedDatabaseConfigurer(ClassUtils.forName("org.h2.Driver", H2EmbeddedDatabaseConfigurer.class.getClassLoader()));
        }
        return INSTANCE;
    }

    private H2EmbeddedDatabaseConfigurer(Class<? extends Driver> driverClass) {
        this.driverClass = driverClass;
    }

    @Override
    public void configureConnectionProperties(ConnectionProperties properties, String databaseName) {
        properties.setDriverClass(this.driverClass);
        properties.setUrl(String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1", databaseName));
        properties.setUsername("sa");
        properties.setPassword("");
    }
}

