/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import javax.persistence.metamodel.Metamodel;
import org.springframework.data.jpa.mapping.JpaPersistentEntity;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.IdPropertyIdentifierAccessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

class JpaPersistentEntityImpl<T>
extends BasicPersistentEntity<T, JpaPersistentProperty>
implements JpaPersistentEntity<T> {
    private final ProxyIdAccessor proxyIdAccessor;

    public JpaPersistentEntityImpl(TypeInformation<T> information, Metamodel metamodel) {
        super(information, null);
        Assert.notNull(metamodel, "Metamodel must not be null!");
        this.proxyIdAccessor = PersistenceProvider.fromMetamodel(metamodel);
    }

    @Override
    protected JpaPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(JpaPersistentProperty property) {
        return property.isIdProperty() ? property : null;
    }

    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        return new JpaProxyAwareIdentifierAccessor(this, bean, this.proxyIdAccessor);
    }

    private static class JpaProxyAwareIdentifierAccessor
    extends IdPropertyIdentifierAccessor {
        private final Object bean;
        private final ProxyIdAccessor proxyIdAccessor;

        public JpaProxyAwareIdentifierAccessor(JpaPersistentEntity<?> entity, Object bean, ProxyIdAccessor proxyIdAccessor) {
            super(entity, bean);
            Assert.notNull(proxyIdAccessor, "Proxy identifier accessor must not be null!");
            this.proxyIdAccessor = proxyIdAccessor;
            this.bean = bean;
        }

        public Object getIdentifier() {
            return this.proxyIdAccessor.shouldUseAccessorFor(this.bean) ? this.proxyIdAccessor.getIdentifierFrom(this.bean) : super.getIdentifier();
        }
    }
}

