/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.internal.EC2MetadataClient;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceProfileCredentialsProvider
implements AWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(InstanceProfileCredentialsProvider.class);
    private static final int REFRESH_THRESHOLD = 3600000;
    private static final int EXPIRATION_THRESHOLD = 900000;
    protected volatile AWSCredentials credentials;
    protected volatile Date credentialsExpiration;
    protected volatile Date lastInstanceProfileCheck;

    public AWSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.loadCredentials();
        }
        if (this.expired()) {
            throw new AmazonClientException("The credentials received from the Amazon EC2 metadata service have expired");
        }
        return this.credentials;
    }

    public void refresh() {
        this.credentials = null;
    }

    protected boolean needsToLoadCredentials() {
        if (this.credentials == null) {
            return true;
        }
        if (this.credentialsExpiration != null && this.isWithinExpirationThreshold()) {
            return true;
        }
        return this.lastInstanceProfileCheck != null && this.isPastRefreshThreshold();
    }

    private boolean isWithinExpirationThreshold() {
        return this.credentialsExpiration.getTime() - System.currentTimeMillis() < 900000L;
    }

    private boolean isPastRefreshThreshold() {
        return System.currentTimeMillis() - this.lastInstanceProfileCheck.getTime() > 3600000L;
    }

    private boolean expired() {
        return this.credentialsExpiration != null && this.credentialsExpiration.getTime() < System.currentTimeMillis();
    }

    private synchronized void loadCredentials() {
        if (!this.needsToLoadCredentials()) {
            return;
        }
        try {
            this.lastInstanceProfileCheck = new Date();
            String credentialsResponse = new EC2MetadataClient().getDefaultCredentials();
            JSONObject jsonObject = new JSONObject(credentialsResponse);
            this.credentials = jsonObject.has("Token") ? new BasicSessionCredentials(jsonObject.getString("AccessKeyId"), jsonObject.getString("SecretAccessKey"), jsonObject.getString("Token")) : new BasicAWSCredentials(jsonObject.getString("AccessKeyId"), jsonObject.getString("SecretAccessKey"));
            if (jsonObject.has("Expiration")) {
                String expiration = jsonObject.getString("Expiration");
                expiration = expiration.replaceAll("\\+0000$", "Z");
                this.credentialsExpiration = new DateUtils().parseIso8601Date(expiration);
            }
        }
        catch (IOException e) {
            this.handleError("Unable to load credentials from Amazon EC2 metadata service", e);
        }
        catch (JSONException e) {
            this.handleError("Unable to parse credentials from Amazon EC2 metadata service", e);
        }
        catch (ParseException e) {
            this.handleError("Unable to parse credentials expiration date from Amazon EC2 metadata service", e);
        }
    }

    private void handleError(String errorMessage, Exception e) {
        if (this.credentials == null || this.expired()) {
            throw new AmazonClientException(errorMessage, e);
        }
        LOG.debug(errorMessage, e);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

