/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopStepConfig
implements Serializable {
    private String jar;
    private Map<String, String> properties;
    private String mainClass;
    private ListWithAutoConstructFlag<String> args;

    public String getJar() {
        return this.jar;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public HadoopStepConfig withJar(String jar) {
        this.jar = jar;
        return this;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public HadoopStepConfig withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public HadoopStepConfig addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public HadoopStepConfig clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public HadoopStepConfig withMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new ListWithAutoConstructFlag();
            this.args.setAutoConstruct(true);
        }
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
        argsCopy.addAll(args);
        this.args = argsCopy;
    }

    public HadoopStepConfig withArgs(String ... args) {
        if (this.getArgs() == null) {
            this.setArgs(new ArrayList<String>(args.length));
        }
        for (String value : args) {
            this.getArgs().add(value);
        }
        return this;
    }

    public HadoopStepConfig withArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
        } else {
            ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
            argsCopy.addAll(args);
            this.args = argsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJar() != null) {
            sb.append("Jar: " + this.getJar() + ",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: " + this.getProperties() + ",");
        }
        if (this.getMainClass() != null) {
            sb.append("MainClass: " + this.getMainClass() + ",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: " + this.getArgs());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJar() == null ? 0 : this.getJar().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getMainClass() == null ? 0 : this.getMainClass().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HadoopStepConfig)) {
            return false;
        }
        HadoopStepConfig other = (HadoopStepConfig)obj;
        if (other.getJar() == null ^ this.getJar() == null) {
            return false;
        }
        if (other.getJar() != null && !other.getJar().equals(this.getJar())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getMainClass() == null ^ this.getMainClass() == null) {
            return false;
        }
        if (other.getMainClass() != null && !other.getMainClass().equals(this.getMainClass())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        return other.getArgs() == null || other.getArgs().equals(this.getArgs());
    }
}

