/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.audit.provider;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.audit.logger.ReadLogger;
import org.duracloud.audit.logger.WriteLogger;
import org.duracloud.audit.task.AuditTask;
import org.duracloud.common.error.NoUserLoggedInException;
import org.duracloud.common.model.AclType;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.common.util.UserUtil;
import org.duracloud.storage.provider.StorageProvider;

public class AuditStorageProvider
implements StorageProvider {
    private StorageProvider target;
    private String account;
    private String storeId;
    private String storeType;
    private UserUtil userUtil;
    private TaskQueue taskQueue;
    private ReadLogger readLogger;
    private WriteLogger writeLogger;

    public AuditStorageProvider(StorageProvider target, String account, String storeId, String storeType, UserUtil userUtil, TaskQueue taskQueue) {
        this.target = target;
        this.account = account;
        this.storeId = storeId;
        this.storeType = storeType;
        this.userUtil = userUtil;
        this.taskQueue = taskQueue;
        this.readLogger = new ReadLogger();
        this.writeLogger = new WriteLogger();
    }

    protected void setLoggers(ReadLogger readLogger, WriteLogger writeLogger) {
        this.readLogger = readLogger;
        this.writeLogger = writeLogger;
    }

    private void submitWriteTask(String action, String spaceId, String contentId, String contentChecksum, String contentMimetype, String contentSize, Map<String, String> contentProperties, String spaceACLs, String sourceSpaceId, String sourceContentId) {
        AuditTask task = new AuditTask();
        task.setAction(action);
        task.setUserId(this.getUserId());
        task.setDateTime(String.valueOf(System.currentTimeMillis()));
        task.setAccount(this.account);
        task.setStoreId(this.storeId);
        task.setStoreType(this.storeType);
        task.setSpaceId(spaceId);
        task.setSpaceACLs(spaceACLs);
        task.setContentId(contentId);
        task.setContentChecksum(contentChecksum);
        task.setContentMimetype(contentMimetype);
        task.setContentSize(contentSize);
        task.setContentProperties(contentProperties);
        task.setSourceSpaceId(sourceSpaceId);
        task.setSourceContentId(sourceContentId);
        Task writeTask = task.writeTask();
        this.taskQueue.put(writeTask);
        this.writeLogger.log(writeTask);
    }

    private void submitReadTask(String action, String spaceId, String contentId) {
        AuditTask task = new AuditTask();
        task.setAction(action);
        task.setUserId(this.getUserId());
        task.setDateTime(String.valueOf(System.currentTimeMillis()));
        task.setAccount(this.account);
        task.setStoreId(this.storeId);
        task.setStoreType(this.storeType);
        task.setSpaceId(spaceId);
        task.setContentId(contentId);
        this.readLogger.log(task.writeTask());
    }

    private String getUserId() {
        try {
            return this.userUtil.getCurrentUsername();
        }
        catch (NoUserLoggedInException e) {
            return "not-applicable";
        }
    }

    @Override
    public Iterator<String> getSpaces() {
        Iterator<String> spaces = this.target.getSpaces();
        String action = AuditTask.ActionType.GET_SPACES.name();
        this.submitReadTask(action, "not-applicable", "not-applicable");
        return spaces;
    }

    @Override
    public Iterator<String> getSpaceContents(String spaceId, String prefix) {
        Iterator<String> spaceContents = this.target.getSpaceContents(spaceId, prefix);
        String action = AuditTask.ActionType.GET_SPACE_CONTENTS.name();
        this.submitReadTask(action, spaceId, "not-applicable");
        return spaceContents;
    }

    @Override
    public List<String> getSpaceContentsChunked(String spaceId, String prefix, long maxResults, String marker) {
        List<String> spaceContents = this.target.getSpaceContentsChunked(spaceId, prefix, maxResults, marker);
        String action = AuditTask.ActionType.GET_SPACE_CONTENTS_CHUNKED.name();
        this.submitReadTask(action, spaceId, "not-applicable");
        return spaceContents;
    }

    @Override
    public Map<String, String> getSpaceProperties(String spaceId) {
        Map<String, String> spaceProps = this.target.getSpaceProperties(spaceId);
        String action = AuditTask.ActionType.GET_SPACE_PROPERTIES.name();
        this.submitReadTask(action, spaceId, "not-applicable");
        return spaceProps;
    }

    @Override
    public Map<String, AclType> getSpaceACLs(String spaceId) {
        Map<String, AclType> spaceAcls = this.target.getSpaceACLs(spaceId);
        String action = AuditTask.ActionType.GET_SPACE_ACLS.name();
        this.submitReadTask(action, spaceId, "not-applicable");
        return spaceAcls;
    }

    @Override
    public InputStream getContent(String spaceId, String contentId) {
        InputStream content = this.target.getContent(spaceId, contentId);
        String action = AuditTask.ActionType.GET_CONTENT.name();
        this.submitReadTask(action, spaceId, contentId);
        return content;
    }

    @Override
    public Map<String, String> getContentProperties(String spaceId, String contentId) {
        Map<String, String> contentProps = this.target.getContentProperties(spaceId, contentId);
        String action = AuditTask.ActionType.GET_CONTENT_PROPERTIES.name();
        this.submitReadTask(action, spaceId, contentId);
        return contentProps;
    }

    @Override
    public void createSpace(String spaceId) {
        this.target.createSpace(spaceId);
        String action = AuditTask.ActionType.CREATE_SPACE.name();
        this.submitWriteTask(action, spaceId, "not-applicable", "not-applicable", "not-applicable", "not-applicable", null, null, "not-applicable", "not-applicable");
    }

    @Override
    public void deleteSpace(String spaceId) {
        this.target.deleteSpace(spaceId);
        String action = AuditTask.ActionType.DELETE_SPACE.name();
        this.submitWriteTask(action, spaceId, "not-applicable", "not-applicable", "not-applicable", "not-applicable", null, null, "not-applicable", "not-applicable");
    }

    @Override
    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) {
        this.target.setSpaceACLs(spaceId, spaceACLs);
        String action = AuditTask.ActionType.SET_SPACE_ACLS.name();
        this.submitWriteTask(action, spaceId, "not-applicable", "not-applicable", "not-applicable", "not-applicable", null, spaceACLs == null ? null : spaceACLs.toString(), "not-applicable", "not-applicable");
    }

    @Override
    public String addContent(String spaceId, String contentId, String contentMimeType, Map<String, String> userProperties, long contentSize, String contentChecksum, InputStream content) {
        contentChecksum = this.target.addContent(spaceId, contentId, contentMimeType, userProperties, contentSize, contentChecksum, content);
        String action = AuditTask.ActionType.ADD_CONTENT.name();
        this.submitWriteTask(action, spaceId, contentId, contentChecksum, contentMimeType, String.valueOf(contentSize), userProperties, null, "not-applicable", "not-applicable");
        return contentChecksum;
    }

    @Override
    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        String contentChecksum = this.target.copyContent(sourceSpaceId, sourceContentId, destSpaceId, destContentId);
        Map<String, String> props = this.target.getContentProperties(sourceSpaceId, sourceContentId);
        String contentMimetype = props.get("content-mimetype");
        String contentSize = props.get("content-size");
        String action = AuditTask.ActionType.COPY_CONTENT.name();
        this.submitWriteTask(action, destSpaceId, destContentId, contentChecksum, contentMimetype, contentSize, props, null, sourceSpaceId, sourceContentId);
        return contentChecksum;
    }

    @Override
    public void deleteContent(String spaceId, String contentId) {
        Map<String, String> props = this.target.getContentProperties(spaceId, contentId);
        String contentMimetype = props.get("content-mimetype");
        String contentSize = props.get("content-size");
        String contentChecksum = props.get("content-checksum");
        this.target.deleteContent(spaceId, contentId);
        String action = AuditTask.ActionType.DELETE_CONTENT.name();
        this.submitWriteTask(action, spaceId, contentId, contentChecksum, contentMimetype, contentSize, null, null, "not-applicable", "not-applicable");
    }

    @Override
    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) {
        this.target.setContentProperties(spaceId, contentId, contentProperties);
        String action = AuditTask.ActionType.SET_CONTENT_PROPERTIES.name();
        this.submitWriteTask(action, spaceId, contentId, "not-applicable", "not-applicable", "not-applicable", contentProperties, null, "not-applicable", "not-applicable");
    }
}

