/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import com.jamesmurty.utils.XMLBuilder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.impl.rest.CloudFrontXmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.AWSRequestAuthorizer;
import org.jets3t.service.impl.rest.httpclient.HttpClientAndConnectionManager;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.cloudfront.CustomOrigin;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.Invalidation;
import org.jets3t.service.model.cloudfront.InvalidationList;
import org.jets3t.service.model.cloudfront.InvalidationSummary;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.Origin;
import org.jets3t.service.model.cloudfront.OriginAccessIdentity;
import org.jets3t.service.model.cloudfront.OriginAccessIdentityConfig;
import org.jets3t.service.model.cloudfront.S3Origin;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.jets3t.service.model.cloudfront.StreamingDistributionConfig;
import org.jets3t.service.security.EncryptionUtil;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFrontService
implements AWSRequestAuthorizer {
    private static final Log log = LogFactory.getLog(CloudFrontService.class);
    public static final String ENDPOINT = "https://cloudfront.amazonaws.com/";
    public static final String VERSION = "2010-11-01";
    public static final String XML_NAMESPACE = "http://cloudfront.amazonaws.com/doc/2010-11-01/";
    public static final String DEFAULT_BUCKET_SUFFIX = ".s3.amazonaws.com";
    public static final String ORIGIN_ACCESS_IDENTITY_URI_PATH = "/origin-access-identity/cloudfront";
    public static final String ORIGIN_ACCESS_IDENTITY_PREFIX = "origin-access-identity/cloudfront/";
    private HttpClient httpClient = null;
    private CredentialsProvider credentialsProvider = null;
    private ProviderCredentials credentials = null;
    protected Jets3tProperties jets3tProperties = null;
    private String invokingApplicationDescription = null;
    protected int internalErrorRetryMax = 5;
    protected long timeOffset = 0L;

    public CloudFrontService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties, HostConfiguration hostConfig) throws CloudFrontServiceException {
        this.credentials = credentials;
        this.invokingApplicationDescription = invokingApplicationDescription;
        this.credentialsProvider = credentialsProvider;
        if (jets3tProperties == null) {
            jets3tProperties = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME);
        }
        this.jets3tProperties = jets3tProperties;
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "1");
        this.internalErrorRetryMax = jets3tProperties.getIntProperty("cloudfront-service.internal-error-retry-max", 5);
        if (hostConfig == null) {
            hostConfig = new HostConfiguration();
        }
        HttpClientAndConnectionManager initHttpResult = RestUtils.initHttpConnection(this, hostConfig, jets3tProperties, this.invokingApplicationDescription, this.credentialsProvider);
        this.httpClient = initHttpResult.getHttpClient();
        if (this.jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true)) {
            RestUtils.initHttpProxy(this.httpClient, this.jets3tProperties);
        } else {
            String proxyHostAddress = this.jets3tProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.jets3tProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.jets3tProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.jets3tProperties.getStringProperty("httpclient.proxy-domain", null);
            RestUtils.initHttpProxy(this.httpClient, this.jets3tProperties, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
        }
        this.httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
    }

    public CloudFrontService(ProviderCredentials credentials) throws CloudFrontServiceException {
        this(credentials, null, null, null, null);
    }

    public ProviderCredentials getAWSCredentials() {
        return this.credentials;
    }

    protected Date getCurrentTimeWithOffset() {
        return new Date(System.currentTimeMillis() + this.timeOffset);
    }

    @Override
    public void authorizeHttpRequest(HttpMethod httpMethod) throws Exception {
        String date = ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset());
        httpMethod.setRequestHeader("Date", date);
        String signature = ServiceUtils.signWithHmacSha1(this.getAWSCredentials().getSecretKey(), date);
        String authorizationString = "AWS " + this.getAWSCredentials().getAccessKey() + ":" + signature;
        httpMethod.setRequestHeader("Authorization", authorizationString);
    }

    protected void performRestRequest(HttpMethod httpMethod, int expectedResponseCode) throws CloudFrontServiceException {
        if (httpMethod.getRequestHeader("Date") == null) {
            httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        boolean completedWithoutRecoverableError = true;
        int internalErrorCount = 0;
        try {
            do {
                completedWithoutRecoverableError = true;
                this.authorizeHttpRequest(httpMethod);
                int responseCode = this.httpClient.executeMethod(httpMethod);
                if (responseCode == expectedResponseCode) continue;
                if (responseCode == 500) {
                    long delayMs = 1000L;
                    if (++internalErrorCount < this.internalErrorRetryMax) {
                        log.warn("Encountered " + internalErrorCount + " CloudFront Internal Server error(s), will retry in " + delayMs + "ms");
                        Thread.sleep(delayMs);
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    throw new CloudFrontServiceException("Encountered too many CloudFront Internal Server errors (" + internalErrorCount + "), aborting request.");
                }
                CloudFrontXmlResponsesSaxParser.ErrorHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseErrorResponse(httpMethod.getResponseBodyAsStream());
                CloudFrontServiceException exception = new CloudFrontServiceException("Request failed with CloudFront Service error", responseCode, handler.getType(), handler.getCode(), handler.getMessage(), handler.getDetail(), handler.getRequestId());
                if ("RequestExpired".equals(exception.getErrorCode())) {
                    this.timeOffset = RestUtils.getAWSTimeAdjustment();
                    if (log.isWarnEnabled()) {
                        log.warn("Adjusted time offset in response to RequestExpired error. Local machine and CloudFront server disagree on the time by approximately " + this.timeOffset / 1000L + " seconds. Retrying connection.");
                    }
                    completedWithoutRecoverableError = false;
                    continue;
                }
                throw exception;
            } while (!completedWithoutRecoverableError);
        }
        catch (CloudFrontServiceException e) {
            httpMethod.releaseConnection();
            throw e;
        }
        catch (Throwable t) {
            httpMethod.releaseConnection();
            throw new CloudFrontServiceException("CloudFront Request failed", t);
        }
    }

    protected List<Distribution> listDistributionsImpl(boolean isStreaming, int pagingSize) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Listing " + (isStreaming ? "streaming" : "") + " distributions for AWS user: " + this.getAWSCredentials().getAccessKey());
        }
        try {
            ArrayList<Distribution> distributions = new ArrayList<Distribution>();
            String nextMarker = null;
            boolean incompleteListing = true;
            do {
                String uri = "https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution" : "/distribution") + "?MaxItems=" + pagingSize;
                if (nextMarker != null) {
                    uri = uri + "&Marker=" + nextMarker;
                }
                GetMethod httpMethod = new GetMethod(uri);
                this.performRestRequest(httpMethod, 200);
                CloudFrontXmlResponsesSaxParser.DistributionListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionListResponse(httpMethod.getResponseBodyAsStream());
                distributions.addAll(handler.getDistributions());
                incompleteListing = handler.isTruncated();
                nextMarker = handler.getNextMarker();
                if (!incompleteListing || nextMarker != null) continue;
                throw new CloudFrontServiceException("Unable to retrieve paginated DistributionList results without a valid NextMarker value.");
            } while (incompleteListing);
            return distributions;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution[] listDistributions(int pagingSize) throws CloudFrontServiceException {
        List<Distribution> distributions = this.listDistributionsImpl(false, pagingSize);
        return distributions.toArray(new Distribution[distributions.size()]);
    }

    public StreamingDistribution[] listStreamingDistributions(int pagingSize) throws CloudFrontServiceException {
        List<Distribution> distributions = this.listDistributionsImpl(true, pagingSize);
        return distributions.toArray(new StreamingDistribution[distributions.size()]);
    }

    public Distribution[] listDistributions() throws CloudFrontServiceException {
        return this.listDistributions(100);
    }

    public StreamingDistribution[] listStreamingDistributions() throws CloudFrontServiceException {
        return this.listStreamingDistributions(100);
    }

    public List<Distribution> listDistributionsByBucketName(boolean isStreaming, String bucketName) throws CloudFrontServiceException {
        String s3Endpoint = this.jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
        if (log.isDebugEnabled()) {
            log.debug("Listing " + (isStreaming ? "streaming" : "") + " distributions for the S3 bucket '" + bucketName + "' for AWS user: " + this.getAWSCredentials().getAccessKey());
        }
        ArrayList<Distribution> bucketDistributions = new ArrayList<Distribution>();
        Distribution[] allDistributions = isStreaming ? this.listStreamingDistributions() : this.listDistributions();
        for (int i = 0; i < allDistributions.length; ++i) {
            S3Origin s3Origin;
            Origin origin = allDistributions[i].getOrigin();
            if (!(origin instanceof S3Origin) || !(s3Origin = (S3Origin)origin).getDnsName().equals(bucketName) && !bucketName.equals(ServiceUtils.findBucketNameInHostname(s3Origin.getDnsName(), s3Endpoint))) continue;
            bucketDistributions.add(allDistributions[i]);
        }
        return bucketDistributions;
    }

    public Distribution[] listDistributions(String bucketName) throws CloudFrontServiceException {
        List<Distribution> bucketDistributions = this.listDistributionsByBucketName(false, bucketName);
        return bucketDistributions.toArray(new Distribution[bucketDistributions.size()]);
    }

    public StreamingDistribution[] listStreamingDistributions(String bucketName) throws CloudFrontServiceException {
        List<Distribution> streamingDistributions = this.listDistributionsByBucketName(true, bucketName);
        return streamingDistributions.toArray(new StreamingDistribution[streamingDistributions.size()]);
    }

    protected XMLBuilder buildOrigin(Origin origin) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        if (origin instanceof S3Origin) {
            S3Origin o = (S3Origin)origin;
            XMLBuilder builder = XMLBuilder.create("S3Origin").e("DNSName").t(CloudFrontService.sanitizeS3BucketName(origin.getDnsName())).up();
            if (o.getOriginAccessIdentity() != null) {
                builder.e("OriginAccessIdentity").t(o.getOriginAccessIdentity());
            }
            return builder;
        }
        CustomOrigin o = (CustomOrigin)origin;
        return XMLBuilder.create("CustomOrigin").e("DNSName").t(origin.getDnsName()).up().e("HTTPPort").t("" + o.getHttpPort()).up().e("HTTPSPort").t("" + o.getHttpsPort()).up().e("OriginProtocolPolicy").t(o.getOriginProtocolPolicy().toText());
    }

    protected String buildDistributionConfigXmlDocument(boolean isStreamingDistribution, Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        int i;
        XMLBuilder builder = XMLBuilder.create(isStreamingDistribution ? "StreamingDistributionConfig" : "DistributionConfig").a("xmlns", XML_NAMESPACE);
        builder.importXMLBuilder(this.buildOrigin(origin));
        builder.e("CallerReference").t(callerReference).up();
        for (int i2 = 0; i2 < cnames.length; ++i2) {
            builder.e("CNAME").t(cnames[i2]).up();
        }
        builder.e("Comment").t(comment).up().e("Enabled").t("" + enabled);
        if (defaultRootObject != null) {
            builder.e("DefaultRootObject").t(defaultRootObject).up();
        }
        if (trustedSignerSelf || trustedSignerAwsAccountNumbers != null && trustedSignerAwsAccountNumbers.length > 0) {
            XMLBuilder trustedSigners = builder.e("TrustedSigners");
            if (trustedSignerSelf) {
                trustedSigners.e("Self");
            }
            for (i = 0; trustedSignerAwsAccountNumbers != null && i < trustedSignerAwsAccountNumbers.length; ++i) {
                trustedSigners.e("AWSAccountNumber").t(trustedSignerAwsAccountNumbers[i]);
            }
            builder.up();
        }
        if (loggingStatus != null) {
            builder.e("Logging").e("Bucket").t(loggingStatus.getBucket()).up().e("Prefix").t(loggingStatus.getPrefix()).up().up();
        }
        if (requiredProtocols != null && requiredProtocols.length > 0) {
            XMLBuilder rpsBuilder = builder.e("RequiredProtocols");
            for (i = 0; i < requiredProtocols.length; ++i) {
                rpsBuilder.e("Protocol").t(requiredProtocols[i]).up();
            }
        }
        return builder.asString(null);
    }

    protected Distribution createDistributionImpl(boolean isStreaming, Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Creating " + (isStreaming ? "streaming" : "") + " distribution for origin: " + origin);
        }
        if (callerReference == null) {
            callerReference = "" + System.currentTimeMillis();
        }
        if (cnames == null) {
            cnames = new String[]{};
        }
        if (comment == null) {
            comment = "";
        }
        PostMethod httpMethod = new PostMethod("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution" : "/distribution"));
        try {
            String distributionConfigXml = this.buildDistributionConfigXmlDocument(isStreaming, origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject);
            httpMethod.setRequestEntity(new StringRequestEntity(distributionConfigXml, "text/xml", Constants.DEFAULT_ENCODING));
            this.performRestRequest(httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.DistributionHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionResponse(httpMethod.getResponseBodyAsStream());
            return handler.getDistribution();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution createDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        return this.createDistributionImpl(false, origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject);
    }

    public Distribution createDistribution(Origin origin) throws CloudFrontServiceException {
        return this.createDistribution(origin, null, null, null, true, null);
    }

    public Distribution createDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return this.createDistribution(origin, callerReference, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public Distribution createDistribution(DistributionConfig config) throws CloudFrontServiceException {
        return this.createDistribution(config.getOrigin(), config.getCallerReference(), config.getCNAMEs(), config.getComment(), config.isEnabled(), config.getLoggingStatus(), config.isTrustedSignerSelf(), config.getTrustedSignerAwsAccountNumbers(), config.getRequiredProtocols(), config.getDefaultRootObject());
    }

    public StreamingDistribution createStreamingDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers) throws CloudFrontServiceException {
        return (StreamingDistribution)this.createDistributionImpl(true, origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, null, null);
    }

    public StreamingDistribution createStreamingDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return (StreamingDistribution)this.createDistributionImpl(true, origin, callerReference, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    protected Distribution getDistributionInfoImpl(boolean isStreaming, String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting information for " + (isStreaming ? "streaming" : "") + " distribution with id: " + id);
        }
        GetMethod httpMethod = new GetMethod("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + id);
        try {
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionResponse(httpMethod.getResponseBodyAsStream());
            return handler.getDistribution();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution getDistributionInfo(String id) throws CloudFrontServiceException {
        return this.getDistributionInfoImpl(false, id);
    }

    public StreamingDistribution getStreamingDistributionInfo(String id) throws CloudFrontServiceException {
        return (StreamingDistribution)this.getDistributionInfoImpl(true, id);
    }

    protected DistributionConfig getDistributionConfigImpl(boolean isStreaming, String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting configuration for " + (isStreaming ? "streaming" : "") + " distribution with id: " + id);
        }
        GetMethod httpMethod = new GetMethod("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + id + "/config");
        try {
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionConfigResponse(httpMethod.getResponseBodyAsStream());
            DistributionConfig config = handler.getDistributionConfig();
            config.setEtag(httpMethod.getResponseHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public DistributionConfig getDistributionConfig(String id) throws CloudFrontServiceException {
        return this.getDistributionConfigImpl(false, id);
    }

    public StreamingDistributionConfig getStreamingDistributionConfig(String id) throws CloudFrontServiceException {
        return (StreamingDistributionConfig)this.getDistributionConfigImpl(true, id);
    }

    protected DistributionConfig updateDistributionConfigImpl(boolean isStreaming, String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        DistributionConfig oldConfig;
        if (log.isDebugEnabled()) {
            log.debug("Updating configuration of " + (isStreaming ? "streaming" : "") + "distribution with id: " + id);
        }
        DistributionConfig distributionConfig = oldConfig = isStreaming ? this.getStreamingDistributionConfig(id) : this.getDistributionConfig(id);
        if (cnames == null) {
            cnames = oldConfig.getCNAMEs();
        }
        if (comment == null) {
            comment = oldConfig.getComment();
        }
        if (origin == null) {
            origin = oldConfig.getOrigin();
        }
        PutMethod httpMethod = new PutMethod("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + id + "/config");
        try {
            String distributionConfigXml = this.buildDistributionConfigXmlDocument(isStreaming, origin, oldConfig.getCallerReference(), cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject);
            httpMethod.setRequestEntity(new StringRequestEntity(distributionConfigXml, "text/xml", Constants.DEFAULT_ENCODING));
            httpMethod.setRequestHeader("If-Match", oldConfig.getEtag());
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionConfigResponse(httpMethod.getResponseBodyAsStream());
            DistributionConfig config = handler.getDistributionConfig();
            config.setEtag(httpMethod.getResponseHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public DistributionConfig updateDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        return this.updateDistributionConfigImpl(false, id, origin, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject);
    }

    public StreamingDistributionConfig updateStreamingDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return (StreamingDistributionConfig)this.updateDistributionConfigImpl(true, id, origin, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public StreamingDistributionConfig updateStreamingDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers) throws CloudFrontServiceException {
        return (StreamingDistributionConfig)this.updateDistributionConfigImpl(true, id, origin, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, null, null);
    }

    public DistributionConfig updateDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return this.updateDistributionConfig(id, origin, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public DistributionConfig updateDistributionConfig(String id, DistributionConfig config) throws CloudFrontServiceException {
        return this.updateDistributionConfig(id, config.getOrigin(), config.getCNAMEs(), config.getComment(), config.isEnabled(), config.getLoggingStatus(), config.isTrustedSignerSelf(), config.getTrustedSignerAwsAccountNumbers(), config.getRequiredProtocols(), config.getDefaultRootObject());
    }

    public void disableDistributionForDeletion(String id) throws CloudFrontServiceException {
        this.updateDistributionConfig(id, null, new String[0], "Disabled prior to deletion", false, null);
    }

    public void disableStreamingDistributionForDeletion(String id) throws CloudFrontServiceException {
        this.updateStreamingDistributionConfig(id, null, new String[0], "Disabled prior to deletion", false, null);
    }

    protected void deleteDistributionImpl(boolean isStreaming, String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Deleting " + (isStreaming ? "streaming" : "") + "distribution with id: " + id);
        }
        DistributionConfig currentConfig = isStreaming ? this.getStreamingDistributionConfig(id) : this.getDistributionConfig(id);
        DeleteMethod httpMethod = new DeleteMethod("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + id);
        try {
            httpMethod.setRequestHeader("If-Match", currentConfig.getEtag());
            this.performRestRequest(httpMethod, 204);
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public void deleteDistribution(String id) throws CloudFrontServiceException {
        this.deleteDistributionImpl(false, id);
    }

    public void deleteStreamingDistribution(String id) throws CloudFrontServiceException {
        this.deleteDistributionImpl(true, id);
    }

    public OriginAccessIdentity createOriginAccessIdentity(String callerReference, String comment) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Creating origin access identity");
        }
        PostMethod httpMethod = new PostMethod("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront");
        if (callerReference == null) {
            callerReference = "" + System.currentTimeMillis();
        }
        try {
            XMLBuilder builder = XMLBuilder.create("CloudFrontOriginAccessIdentityConfig").a("xmlns", XML_NAMESPACE).e("CallerReference").t(callerReference).up().e("Comment").t(comment);
            httpMethod.setRequestEntity(new StringRequestEntity(builder.asString(null), "text/xml", Constants.DEFAULT_ENCODING));
            this.performRestRequest(httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentity(httpMethod.getResponseBodyAsStream());
            return handler.getOriginAccessIdentity();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public List<OriginAccessIdentity> getOriginAccessIdentityList() throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting list of origin access identities");
        }
        GetMethod httpMethod = new GetMethod("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront");
        try {
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityListResponse(httpMethod.getResponseBodyAsStream());
            return handler.getOriginAccessIdentityList();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentity getOriginAccessIdentity(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting information for origin access identity with id: " + id);
        }
        GetMethod httpMethod = new GetMethod("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/" + id);
        try {
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentity(httpMethod.getResponseBodyAsStream());
            return handler.getOriginAccessIdentity();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentityConfig getOriginAccessIdentityConfig(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting config for origin access identity with id: " + id);
        }
        GetMethod httpMethod = new GetMethod("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/" + id + "/config");
        try {
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityConfig(httpMethod.getResponseBodyAsStream());
            OriginAccessIdentityConfig config = handler.getOriginAccessIdentityConfig();
            config.setEtag(httpMethod.getResponseHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentityConfig updateOriginAccessIdentityConfig(String id, String comment) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Updating configuration of origin access identity with id: " + id);
        }
        OriginAccessIdentityConfig oldConfig = this.getOriginAccessIdentityConfig(id);
        if (comment == null) {
            comment = oldConfig.getComment();
        }
        PutMethod httpMethod = new PutMethod("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/" + id + "/config");
        try {
            XMLBuilder builder = XMLBuilder.create("CloudFrontOriginAccessIdentityConfig").a("xmlns", XML_NAMESPACE).e("CallerReference").t(oldConfig.getCallerReference()).up().e("Comment").t(comment);
            httpMethod.setRequestEntity(new StringRequestEntity(builder.asString(null), "text/xml", Constants.DEFAULT_ENCODING));
            httpMethod.setRequestHeader("If-Match", oldConfig.getEtag());
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityConfig(httpMethod.getResponseBodyAsStream());
            OriginAccessIdentityConfig config = handler.getOriginAccessIdentityConfig();
            config.setEtag(httpMethod.getResponseHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public void deleteOriginAccessIdentity(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Deleting origin access identity with id: " + id);
        }
        OriginAccessIdentityConfig currentConfig = this.getOriginAccessIdentityConfig(id);
        DeleteMethod httpMethod = new DeleteMethod("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/" + id);
        try {
            httpMethod.setRequestHeader("If-Match", currentConfig.getEtag());
            this.performRestRequest(httpMethod, 204);
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Invalidation invalidateObjects(String distributionId, String[] objectKeys, String callerReference) throws CloudFrontServiceException {
        PostMethod httpMethod = new PostMethod("https://cloudfront.amazonaws.com/2010-11-01/distribution/" + distributionId + "/invalidation");
        try {
            XMLBuilder builder = XMLBuilder.create("InvalidationBatch");
            for (String objectPath : objectKeys) {
                String encodedPath = RestUtils.encodeUrlPath(objectPath, "/");
                if (!encodedPath.startsWith("/")) {
                    encodedPath = "/" + encodedPath;
                }
                builder.e("Path").t(encodedPath);
            }
            builder.e("CallerReference").t(callerReference);
            httpMethod.setRequestEntity(new StringRequestEntity(builder.asString(null), "text/xml", Constants.DEFAULT_ENCODING));
            this.performRestRequest(httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.InvalidationHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationResponse(httpMethod.getResponseBodyAsStream());
            return handler.getInvalidation();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Invalidation invalidateObjects(String distributionId, S3Object[] objects, String callerReference) throws CloudFrontServiceException {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.invalidateObjects(distributionId, objectKeys, callerReference);
    }

    public Invalidation getInvalidation(String distributionId, String invalidationId) throws CloudFrontServiceException {
        GetMethod httpMethod = new GetMethod("https://cloudfront.amazonaws.com/2010-11-01/distribution/" + distributionId + "/invalidation/" + invalidationId);
        try {
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.InvalidationHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationResponse(httpMethod.getResponseBodyAsStream());
            return handler.getInvalidation();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public InvalidationList listInvalidations(String distributionId, String nextMarker, int pagingSize) throws CloudFrontServiceException {
        try {
            String uri = "https://cloudfront.amazonaws.com/2010-11-01/distribution/" + distributionId + "/invalidation" + "?MaxItems=" + pagingSize;
            if (nextMarker != null) {
                uri = uri + "&Marker=" + nextMarker;
            }
            GetMethod httpMethod = new GetMethod(uri);
            this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.InvalidationListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationListResponse(httpMethod.getResponseBodyAsStream());
            return handler.getInvalidationList();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public List<InvalidationSummary> listInvalidations(String distributionId) throws CloudFrontServiceException {
        try {
            ArrayList<InvalidationSummary> invalidationSummaries = new ArrayList<InvalidationSummary>();
            String nextMarker = null;
            boolean incompleteListing = true;
            do {
                InvalidationList invalidationList = this.listInvalidations(distributionId, nextMarker, 100);
                invalidationSummaries.addAll(invalidationList.getInvalidationSummaries());
                incompleteListing = invalidationList.isTruncated();
                nextMarker = invalidationList.getNextMarker();
                if (!incompleteListing || nextMarker != null) continue;
                throw new CloudFrontServiceException("Unable to retrieve paginated InvalidationList results without a valid NextMarker value.");
            } while (incompleteListing);
            return invalidationSummaries;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public static String sanitizeS3BucketName(String proposedBucketName) {
        if (!proposedBucketName.endsWith(DEFAULT_BUCKET_SUFFIX)) {
            log.warn("Bucket names used within the CloudFront service should be specified as full S3 subdomain paths like 'jets3t.s3.amazonaws.com'. Repairing faulty bucket name value \"" + proposedBucketName + "\" by adding suffix " + "'" + DEFAULT_BUCKET_SUFFIX + "'.");
            return proposedBucketName + DEFAULT_BUCKET_SUFFIX;
        }
        return proposedBucketName;
    }

    protected static String makeStringUrlSafe(String str) throws UnsupportedEncodingException {
        return ServiceUtils.toBase64(str.getBytes("UTF-8")).replace('+', '-').replace('=', '_').replace('/', '~');
    }

    protected static String makeBytesUrlSafe(byte[] bytes) throws UnsupportedEncodingException {
        return ServiceUtils.toBase64(bytes).replace('+', '-').replace('=', '_').replace('/', '~');
    }

    public static String buildPolicyForSignedUrl(String resourcePath, Date epochDateLessThan, String limitToIpAddressCIDR, Date epochDateGreaterThan) throws CloudFrontServiceException {
        if (epochDateLessThan == null) {
            throw new CloudFrontServiceException("epochDateLessThan must be provided to sign CloudFront URLs");
        }
        if (resourcePath == null) {
            resourcePath = "*";
        }
        String ipAddress = limitToIpAddressCIDR == null ? "0.0.0.0/0" : limitToIpAddressCIDR;
        String policy = "{\"Statement\": [{\"Resource\":\"" + resourcePath + "\"" + ",\"Condition\":{" + "\"DateLessThan\":{\"AWS:EpochTime\":" + epochDateLessThan.getTime() / 1000L + "}" + ",\"IpAddress\":{\"AWS:SourceIp\":\"" + ipAddress + "\"}" + (epochDateGreaterThan == null ? "" : ",\"DateGreaterThan\":{\"AWS:EpochTime\":" + epochDateGreaterThan.getTime() / 1000L + "}") + "}}]}";
        return policy;
    }

    public static String signUrl(String resourceUrlOrPath, String keyPairId, byte[] derPrivateKey, String policy) throws CloudFrontServiceException {
        try {
            byte[] signatureBytes = EncryptionUtil.signWithRsaSha1(derPrivateKey, policy.getBytes("UTF-8"));
            String urlSafePolicy = CloudFrontService.makeStringUrlSafe(policy);
            String urlSafeSignature = CloudFrontService.makeBytesUrlSafe(signatureBytes);
            String signedUrl = resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Policy=" + urlSafePolicy + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
            return signedUrl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public static String signUrlCanned(String resourceUrlOrPath, String keyPairId, byte[] derPrivateKey, Date epochDateLessThan) throws CloudFrontServiceException {
        try {
            String cannedPolicy = "{\"Statement\":[{\"Resource\":\"" + resourceUrlOrPath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + epochDateLessThan.getTime() / 1000L + "}}}]}";
            byte[] signatureBytes = EncryptionUtil.signWithRsaSha1(derPrivateKey, cannedPolicy.getBytes("UTF-8"));
            String urlSafeSignature = CloudFrontService.makeBytesUrlSafe(signatureBytes);
            String signedUrl = resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Expires=" + epochDateLessThan.getTime() / 1000L + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
            return signedUrl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }
}

