/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class BeanWrapper<T>
implements PersistentPropertyAccessor {
    private final T bean;

    protected BeanWrapper(T bean) {
        Assert.notNull(bean, "Bean must not be null!");
        this.bean = bean;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, Object value) {
        Assert.notNull(property, "PersistentProperty must not be null!");
        try {
            if (!property.usePropertyAccess()) {
                ReflectionUtils.makeAccessible(property.getField());
                ReflectionUtils.setField(property.getField(), this.bean, value);
                return;
            }
            Method setter = property.getSetter();
            if (property.usePropertyAccess() && setter != null) {
                ReflectionUtils.makeAccessible(setter);
                ReflectionUtils.invokeMethod(setter, this.bean, value);
            }
        }
        catch (IllegalStateException e) {
            throw new MappingException("Could not set object property!", e);
        }
    }

    @Override
    public Object getProperty(PersistentProperty<?> property) {
        return this.getProperty(property, property.getType());
    }

    public <S> S getProperty(PersistentProperty<?> property, Class<? extends S> type) {
        Assert.notNull(property, "PersistentProperty must not be null!");
        try {
            if (!property.usePropertyAccess()) {
                Field field = property.getField();
                ReflectionUtils.makeAccessible(field);
                return (S)ReflectionUtils.getField(field, this.bean);
            }
            Method getter = property.getGetter();
            if (property.usePropertyAccess() && getter != null) {
                ReflectionUtils.makeAccessible(getter);
                return (S)ReflectionUtils.invokeMethod(getter, this.bean);
            }
            return null;
        }
        catch (IllegalStateException e) {
            throw new MappingException(String.format("Could not read property %s of %s!", property.toString(), this.bean.toString()), e);
        }
    }

    public T getBean() {
        return this.bean;
    }
}

