/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class MethodWriter {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(MethodWriter.class);

    private MethodWriter() {
    }

    public static CtMethod write(CtClass target, String format, Object ... args) throws CannotCompileException {
        String body = String.format(format, args);
        log.debugf("writing method into [%s]:%n%s", (Object)target.getName(), (Object)body);
        CtMethod method = CtNewMethod.make(body, target);
        target.addMethod(method);
        return method;
    }

    public static CtMethod addGetter(CtClass target, String field, String name) {
        try {
            log.debugf("Writing getter method [%s] into [%s] for field [%s]", (Object)name, (Object)target.getName(), (Object)field);
            CtMethod method = CtNewMethod.getter(name, target.getField(field));
            target.addMethod(method);
            return method;
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance class [%s] to add method [%s] for field [%s]", target.getName(), name, field);
            throw new EnhancementException(msg, cce);
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance class [%s] to add method [%s] for field [%s]", target.getName(), name, field);
            throw new EnhancementException(msg, nfe);
        }
    }

    public static CtMethod addSetter(CtClass target, String field, String name) {
        try {
            log.debugf("Writing setter method [%s] into [%s] for field [%s]", (Object)name, (Object)target.getName(), (Object)field);
            CtMethod method = CtNewMethod.setter(name, target.getField(field));
            target.addMethod(method);
            return method;
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance class [%s] to add method [%s] for field [%s]", target.getName(), name, field);
            throw new EnhancementException(msg, cce);
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance class [%s] to add method [%s] for field [%s]", target.getName(), name, field);
            throw new EnhancementException(msg, nfe);
        }
    }

    public static int addMethod(ConstPool cPool, CtMethod method) {
        return cPool.addMethodrefInfo(cPool.getThisClassInfo(), method.getName(), method.getSignature());
    }
}

