/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.enhance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

public class EnhancementTask
extends Task
implements EnhancementContext {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private final ClassPool classPool = new ClassPool(false);
    private final Enhancer enhancer = new Enhancer(this);

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() throws BuildException {
        this.log("Starting Hibernate EnhancementTask execution", 2);
        Project project = this.getProject();
        for (FileSet fileSet : this.filesets) {
            File fileSetBaseDir = fileSet.getDir(project);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            for (String relativeIncludedFileName : directoryScanner.getIncludedFiles()) {
                File javaClassFile = new File(fileSetBaseDir, relativeIncludedFileName);
                if (!javaClassFile.exists()) continue;
                this.processClassFile(javaClassFile);
            }
        }
    }

    private void processClassFile(File javaClassFile) {
        try {
            CtClass ctClass = this.classPool.makeClass(new FileInputStream(javaClassFile));
            if (this.isEntityClass(ctClass)) {
                this.processEntityClassFile(javaClassFile, ctClass);
            } else if (this.isCompositeClass(ctClass)) {
                this.processCompositeClassFile(javaClassFile, ctClass);
            }
        }
        catch (IOException e) {
            throw new BuildException(String.format("Error processing included file [%s]", javaClassFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private void processEntityClassFile(File javaClassFile, CtClass ctClass) {
        try {
            byte[] result = this.enhancer.enhance(ctClass.getName(), ctClass.toBytecode());
            if (result != null) {
                this.writeEnhancedClass(javaClassFile, result);
            }
        }
        catch (Exception e) {
            this.log("Unable to enhance class [" + ctClass.getName() + "]", e, 1);
        }
    }

    private void processCompositeClassFile(File javaClassFile, CtClass ctClass) {
        try {
            byte[] result = this.enhancer.enhanceComposite(ctClass.getName(), ctClass.toBytecode());
            if (result != null) {
                this.writeEnhancedClass(javaClassFile, result);
            }
        }
        catch (Exception e) {
            this.log("Unable to enhance class [" + ctClass.getName() + "]", e, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEnhancedClass(File javaClassFile, byte[] result) {
        try {
            if (javaClassFile.delete()) {
                if (!javaClassFile.createNewFile()) {
                    this.log("Unable to recreate class file [" + javaClassFile.getName() + "]", 2);
                }
            } else {
                this.log("Unable to delete class file [" + javaClassFile.getName() + "]", 2);
            }
            FileOutputStream outputStream = new FileOutputStream(javaClassFile, false);
            try {
                outputStream.write(result);
                outputStream.flush();
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException outputStream) {
        }
        catch (IOException e) {
            throw new BuildException(String.format("Error processing included file [%s]", javaClassFile.getAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    public ClassLoader getLoadingClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public boolean isEntityClass(CtClass classDescriptor) {
        return classDescriptor.hasAnnotation(Entity.class);
    }

    @Override
    public boolean isCompositeClass(CtClass classDescriptor) {
        return classDescriptor.hasAnnotation(Embeddable.class);
    }

    @Override
    public boolean doBiDirectionalAssociationManagement(CtField field) {
        return false;
    }

    @Override
    public boolean doDirtyCheckingInline(CtClass classDescriptor) {
        return true;
    }

    @Override
    public boolean doExtendedEnhancement(CtClass classDescriptor) {
        return false;
    }

    @Override
    public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
        return true;
    }

    @Override
    public boolean isLazyLoadable(CtField field) {
        return true;
    }

    @Override
    public boolean isPersistentField(CtField ctField) {
        return !ctField.hasAnnotation(Transient.class);
    }

    @Override
    public boolean isMappedCollection(CtField field) {
        try {
            return field.getAnnotation(OneToMany.class) != null || field.getAnnotation(ManyToMany.class) != null || field.getAnnotation(ElementCollection.class) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public CtField[] order(CtField[] persistentFields) {
        return persistentFields;
    }
}

