/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SimpleTypeInformationMapper
implements TypeInformationMapper {
    private final Map<String, ClassTypeInformation<?>> CACHE = new ConcurrentHashMap();

    public ClassTypeInformation<?> resolveTypeFrom(Object alias) {
        if (!(alias instanceof String)) {
            return null;
        }
        String value = (String)alias;
        if (!StringUtils.hasText(value)) {
            return null;
        }
        ClassTypeInformation<?> information = this.CACHE.get(value);
        if (information != null) {
            return information;
        }
        try {
            information = ClassTypeInformation.from(ClassUtils.forName(value, null));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (information != null) {
            this.CACHE.put(value, information);
        }
        return information;
    }

    @Override
    public String createAliasFor(TypeInformation<?> type) {
        return type.getType().getName();
    }
}

