/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor;
import org.springframework.data.projection.DefaultProjectionInformation;
import org.springframework.data.projection.MapAccessingMethodInterceptor;
import org.springframework.data.projection.ProjectingMethodInterceptor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.PropertyAccessingMethodInterceptor;
import org.springframework.data.projection.TargetAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class ProxyProjectionFactory
implements ProjectionFactory,
ResourceLoaderAware,
BeanClassLoaderAware {
    private static final boolean IS_JAVA_8 = ClassUtils.isPresent("java.util.Optional", ProxyProjectionFactory.class.getClassLoader());
    private ClassLoader classLoader;

    ProxyProjectionFactory() {
    }

    @Override
    @Deprecated
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.classLoader = resourceLoader.getClassLoader();
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public <T> T createProjection(Class<T> projectionType, Object source) {
        Assert.notNull(projectionType, "Projection type must not be null!");
        Assert.isTrue(projectionType.isInterface(), "Projection type must be an interface!");
        if (source == null) {
            return null;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget(source);
        factory.setOpaque(true);
        factory.setInterfaces(projectionType, TargetAware.class);
        if (IS_JAVA_8) {
            factory.addAdvice(new DefaultMethodInvokingMethodInterceptor());
        }
        factory.addAdvice(new TargetAwareMethodInterceptor(source.getClass()));
        factory.addAdvice(this.getMethodInterceptor(source, projectionType));
        return (T)factory.getProxy(this.classLoader == null ? ClassUtils.getDefaultClassLoader() : this.classLoader);
    }

    @Override
    public <T> T createProjection(Class<T> projectionType) {
        Assert.notNull(projectionType, "Projection type must not be null!");
        return this.createProjection(projectionType, new HashMap());
    }

    @Override
    public List<String> getInputProperties(Class<?> projectionType) {
        Assert.notNull(projectionType, "Projection type must not be null!");
        ArrayList<String> result = new ArrayList<String>();
        for (PropertyDescriptor descriptor : this.getProjectionInformation(projectionType).getInputProperties()) {
            result.add(descriptor.getName());
        }
        return result;
    }

    @Override
    public ProjectionInformation getProjectionInformation(Class<?> projectionType) {
        return new DefaultProjectionInformation(projectionType);
    }

    private MethodInterceptor getMethodInterceptor(Object source, Class<?> projectionType) {
        MethodInterceptor propertyInvocationInterceptor = source instanceof Map ? new MapAccessingMethodInterceptor((Map)source) : new PropertyAccessingMethodInterceptor(source);
        return new ProjectingMethodInterceptor(this, this.postProcessAccessorInterceptor(propertyInvocationInterceptor, source, projectionType));
    }

    protected MethodInterceptor postProcessAccessorInterceptor(MethodInterceptor interceptor, Object source, Class<?> projectionType) {
        return interceptor;
    }

    private static class TargetAwareMethodInterceptor
    implements MethodInterceptor {
        private static final Method GET_TARGET_CLASS_METHOD;
        private static final Method GET_TARGET_METHOD;
        private final Class<?> targetType;

        public TargetAwareMethodInterceptor(Class<?> targetType) {
            Assert.notNull(targetType, "Target type must not be null!");
            this.targetType = targetType;
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().equals(GET_TARGET_CLASS_METHOD)) {
                return this.targetType;
            }
            if (invocation.getMethod().equals(GET_TARGET_METHOD)) {
                return invocation.getThis();
            }
            return invocation.proceed();
        }

        static {
            try {
                GET_TARGET_CLASS_METHOD = TargetAware.class.getMethod("getTargetClass", new Class[0]);
                GET_TARGET_METHOD = TargetAware.class.getMethod("getTarget", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

