/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.Parameter;
import org.springframework.util.Assert;

public class StringQueryParameterBinder
extends ParameterBinder {
    private final StringQuery query;

    public StringQueryParameterBinder(JpaParameters parameters, Object[] values, StringQuery query) {
        super(parameters, values);
        Assert.notNull(query, "StringQuery must not be null!");
        this.query = query;
    }

    @Override
    protected void bind(Query jpaQuery, JpaParameters.JpaParameter methodParameter, Object value, int position) {
        StringQuery.ParameterBinding binding = this.getBindingFor(jpaQuery, position, methodParameter);
        super.bind(jpaQuery, methodParameter, binding.prepare(value), position);
    }

    private StringQuery.ParameterBinding getBindingFor(Query jpaQuery, int position, Parameter methodParameter) {
        if (this.hasNamedParameter(jpaQuery)) {
            return this.query.getBindingFor(methodParameter.getName());
        }
        try {
            jpaQuery.getParameter(position);
            return this.query.getBindingFor(position);
        }
        catch (IllegalArgumentException o_O) {
            return new StringQuery.ParameterBinding(position);
        }
    }
}

