/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.util.Assert;

public class ParameterBinder {
    static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters; Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters";
    private final JpaParameters parameters;
    private final Iterable<QueryParameterSetter> parameterSetters;
    private final boolean useJpaForPaging;

    ParameterBinder(JpaParameters parameters, Iterable<QueryParameterSetter> parameterSetters) {
        this(parameters, parameterSetters, true);
    }

    public ParameterBinder(JpaParameters parameters, Iterable<QueryParameterSetter> parameterSetters, boolean useJpaForPaging) {
        Assert.notNull((Object)parameters, "JpaParameters must not be null!");
        Assert.notNull(parameterSetters, "Parameter setters must not be null!");
        this.parameters = parameters;
        this.parameterSetters = parameterSetters;
        this.useJpaForPaging = useJpaForPaging;
    }

    public <T extends Query> T bind(T jpaQuery, QueryParameterSetter.QueryMetadata metadata, JpaParametersParameterAccessor accessor) {
        this.bind(metadata.withQuery(jpaQuery), accessor, QueryParameterSetter.ErrorHandling.STRICT);
        return jpaQuery;
    }

    public void bind(QueryParameterSetter.BindableQuery query2, JpaParametersParameterAccessor accessor, QueryParameterSetter.ErrorHandling errorHandling) {
        for (QueryParameterSetter setter : this.parameterSetters) {
            setter.setParameter(query2, accessor, errorHandling);
        }
    }

    Query bindAndPrepare(Query query2, QueryParameterSetter.QueryMetadata metadata, JpaParametersParameterAccessor accessor) {
        this.bind(query2, metadata, accessor);
        if (!this.useJpaForPaging || !this.parameters.hasPageableParameter() || accessor.getPageable().isUnpaged()) {
            return query2;
        }
        query2.setFirstResult((int)accessor.getPageable().getOffset());
        query2.setMaxResults(accessor.getPageable().getPageSize());
        return query2;
    }
}

