/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util.bulk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.duracloud.common.error.ManifestVerifyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestVerifier {
    private final Logger log = LoggerFactory.getLogger(ManifestVerifier.class);
    public static final char DELIM = '\t';
    private File file0;
    private File file1;
    private Map<String, String> entries0;
    private Map<String, String> entries1;
    private List<String> filters;
    private Map<String, ResultEntry> results;

    public ManifestVerifier(File file0, File file1) {
        this.file0 = file0;
        this.file1 = file1;
        this.entries0 = new HashMap<String, String>();
        this.entries1 = new HashMap<String, String>();
        this.filters = new ArrayList<String>();
        this.results = new HashMap<String, ResultEntry>();
    }

    public void report(OutputStream out) {
        String newline = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        String cksum0 = "0:" + FilenameUtils.getName(this.file0.getName());
        String cksum1 = "1:" + FilenameUtils.getName(this.file1.getName());
        sb.append("title,file," + cksum0 + "," + cksum1 + ",state");
        sb.append(newline);
        this.write(out, sb.toString());
        Iterator<ResultEntry> entries = this.resultEntries();
        while (entries.hasNext()) {
            this.write(out, entries.next().toString());
        }
    }

    private void write(OutputStream out, String text) {
        try {
            out.write(text.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<ResultEntry> resultEntries() {
        return this.results.values().iterator();
    }

    public void verify(String ... filters) throws ManifestVerifyException {
        if (filters != null) {
            this.filters = Arrays.asList(filters);
            this.logFilters();
        }
        this.verify();
    }

    public void verify() throws ManifestVerifyException {
        this.loadEntries();
        this.verifyFiles();
    }

    private void loadEntries() {
        this.loadEntries(this.file0, this.entries0);
        this.loadEntries(this.file1, this.entries1);
    }

    private void loadEntries(File file, Map<String, String> entries) {
        InputStream input = this.getInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        String line = this.readLine(br);
        while (line != null) {
            if (!this.isFiltered(line)) {
                this.addEntry(line, entries);
            }
            line = this.readLine(br);
        }
    }

    private boolean isFiltered(String line) {
        for (String filter : this.filters) {
            if (line.indexOf(filter) == -1) continue;
            return true;
        }
        return false;
    }

    protected void addEntry(String line, Map<String, String> entries) {
        String[] cksumFilenamePair = line.split("\\s");
        if (cksumFilenamePair == null || cksumFilenamePair.length != 2) {
            throw new RuntimeException("Invalid manifest file.");
        }
        entries.put(cksumFilenamePair[1], cksumFilenamePair[0]);
    }

    private InputStream getInputStream(File file) {
        try {
            return new AutoCloseInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String readLine(BufferedReader br) {
        try {
            return br.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyFiles() throws ManifestVerifyException {
        ResultEntry entry;
        boolean hasErrors = this.entries0.size() != this.entries1.size();
        for (String name : this.entries0.keySet()) {
            entry = new ResultEntry();
            entry.setTitle(this.titleOf(name));
            entry.setFile(this.fileOf(name));
            entry.setChecksum0(this.entries0.get(name));
            entry.setState(State.MISSING_FROM_1);
            this.results.put(name, entry);
        }
        for (String name : this.entries1.keySet()) {
            entry = this.results.get(name);
            if (null == entry) {
                hasErrors = true;
                entry = new ResultEntry();
                entry.setTitle(this.titleOf(name));
                entry.setFile(this.fileOf(name));
                entry.setChecksum1(this.entries1.get(name));
                entry.setState(State.MISSING_FROM_0);
                this.results.put(name, entry);
                continue;
            }
            entry.setChecksum1(this.entries1.get(name));
            if (entry.getChecksum0().equals(entry.getChecksum1())) {
                entry.setState(State.VALID);
                continue;
            }
            hasErrors = true;
            entry.setState(State.MISMATCH);
        }
        if (hasErrors) {
            throw new ManifestVerifyException("Manifests do not match.");
        }
    }

    protected String titleOf(String name) {
        String pre = "data/";
        int prefixIndex = name.startsWith(pre) ? pre.length() : 0;
        int suffixIndex = name.lastIndexOf(47);
        return name.substring(prefixIndex, suffixIndex);
    }

    protected String fileOf(String name) {
        return FilenameUtils.getName(name);
    }

    private void logFilters() {
        StringBuilder sb = new StringBuilder();
        if (this.filters.size() > 0) {
            sb.append("Filters: [");
            for (String filter : this.filters) {
                sb.append("|" + filter);
            }
            sb.append("|]");
        } else {
            sb.append("NO-FILTERS");
        }
        this.log.info(sb.toString());
    }

    public class ResultEntry {
        private String title;
        private String file;
        private String checksum0 = "";
        private String checksum1 = "";
        private State state;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getChecksum0() {
            return this.checksum0;
        }

        public void setChecksum0(String checksum0) {
            this.checksum0 = checksum0;
        }

        public String getChecksum1() {
            return this.checksum1;
        }

        public void setChecksum1(String checksum1) {
            this.checksum1 = checksum1;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public boolean isError() {
            return !State.VALID.equals((Object)this.state);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getTitle());
            sb.append('\t');
            sb.append(this.getFile());
            sb.append('\t');
            sb.append(this.getChecksum0());
            sb.append('\t');
            sb.append(this.getChecksum1());
            sb.append('\t');
            sb.append((Object)this.getState());
            return sb.toString();
        }
    }

    public static enum State {
        VALID,
        MISMATCH,
        MISSING_FROM_0,
        MISSING_FROM_1;

    }
}

