/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.ehcache.core.PrefixLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcachePrefixLoggerFactory {
    private static final ThreadLocal<Map<String, String>> bindTimeMdc = new ThreadLocal();

    private EhcachePrefixLoggerFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    protected static Map<String, String> getContextMap() {
        return bindTimeMdc.get();
    }

    public static Context withContext(String key, String value) {
        Map<String, String> context = EhcachePrefixLoggerFactory.getOrCreateContextMap();
        Thread creator = Thread.currentThread();
        String old = context.put(key, value);
        if (old == null) {
            return () -> {
                if (creator == Thread.currentThread()) {
                    if (context.remove(key, value) && context.isEmpty()) {
                        bindTimeMdc.remove();
                    }
                } else {
                    throw new UnsupportedOperationException("Context can only be closed by the creator thread");
                }
            };
        }
        return () -> context.replace(key, value, old);
    }

    private static Map<String, String> getOrCreateContextMap() {
        Map<String, String> context = bindTimeMdc.get();
        if (context == null) {
            context = new HashMap<String, String>();
            bindTimeMdc.set(context);
        }
        return context;
    }

    public static Logger getLogger(Class<?> klazz) {
        return EhcachePrefixLoggerFactory.wrappedLogger(klazz, LoggerFactory::getLogger);
    }

    public static Logger getLogger(String name) {
        return EhcachePrefixLoggerFactory.wrappedLogger(name, LoggerFactory::getLogger);
    }

    private static <K> Logger wrappedLogger(K key, Function<K, Logger> loggerGenerator) {
        Map<String, String> context = bindTimeMdc.get();
        Logger logger2 = loggerGenerator.apply(key);
        if (context == null || context.isEmpty()) {
            return logger2;
        }
        String prefix = context.toString();
        return new PrefixLogger(logger2, prefix);
    }

    @FunctionalInterface
    public static interface Context
    extends AutoCloseable {
        @Override
        public void close();
    }
}

