/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.geo;

import java.io.Serializable;
import org.springframework.data.geo.Distance;
import org.springframework.util.Assert;

public class GeoResult<T>
implements Serializable {
    private static final long serialVersionUID = 1637452570977581370L;
    private final T content;
    private final Distance distance;

    public GeoResult(T content, Distance distance) {
        Assert.notNull(content);
        Assert.notNull(distance);
        this.content = content;
        this.distance = distance;
    }

    public T getContent() {
        return this.content;
    }

    public Distance getDistance() {
        return this.distance;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoResult)) {
            return false;
        }
        GeoResult that = (GeoResult)obj;
        return this.content.equals(that.content) && this.distance.equals(that.distance);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.distance.hashCode();
        return result += 31 * this.content.hashCode();
    }

    public String toString() {
        return String.format("GeoResult [content: %s, distance: %s, ]", this.content.toString(), this.distance.toString());
    }
}

