/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.config.DefaultRepositoryBaseClass;
import org.springframework.data.repository.config.RepositoryConfigurationSourceSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AnnotationRepositoryConfigurationSource
extends RepositoryConfigurationSourceSupport {
    private static final String REPOSITORY_IMPLEMENTATION_POSTFIX = "repositoryImplementationPostfix";
    private static final String BASE_PACKAGES = "basePackages";
    private static final String BASE_PACKAGE_CLASSES = "basePackageClasses";
    private static final String NAMED_QUERIES_LOCATION = "namedQueriesLocation";
    private static final String QUERY_LOOKUP_STRATEGY = "queryLookupStrategy";
    private static final String REPOSITORY_FACTORY_BEAN_CLASS = "repositoryFactoryBeanClass";
    private static final String REPOSITORY_BASE_CLASS = "repositoryBaseClass";
    private static final String CONSIDER_NESTED_REPOSITORIES = "considerNestedRepositories";
    private final AnnotationMetadata configMetadata;
    private final AnnotationMetadata enableAnnotationMetadata;
    private final AnnotationAttributes attributes;
    private final ResourceLoader resourceLoader;
    private final boolean hasExplicitFilters;

    public AnnotationRepositoryConfigurationSource(AnnotationMetadata metadata, Class<? extends Annotation> annotation, ResourceLoader resourceLoader, Environment environment) {
        super(environment);
        Assert.notNull(metadata);
        Assert.notNull(annotation);
        Assert.notNull(resourceLoader);
        this.attributes = new AnnotationAttributes(metadata.getAnnotationAttributes(annotation.getName()));
        this.enableAnnotationMetadata = new StandardAnnotationMetadata(annotation);
        this.configMetadata = metadata;
        this.resourceLoader = resourceLoader;
        this.hasExplicitFilters = AnnotationRepositoryConfigurationSource.hasExplicitFilters(this.attributes);
    }

    private static boolean hasExplicitFilters(AnnotationAttributes attributes) {
        for (String attribute : Arrays.asList("includeFilters", "excludeFilters")) {
            if (attributes.getAnnotationArray(attribute).length <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<String> getBasePackages() {
        String[] value = this.attributes.getStringArray("value");
        String[] basePackages = this.attributes.getStringArray(BASE_PACKAGES);
        Class<?>[] basePackageClasses = this.attributes.getClassArray(BASE_PACKAGE_CLASSES);
        if (value.length == 0 && basePackages.length == 0 && basePackageClasses.length == 0) {
            String className = this.configMetadata.getClassName();
            return Collections.singleton(ClassUtils.getPackageName(className));
        }
        HashSet<String> packages = new HashSet<String>();
        packages.addAll(Arrays.asList(value));
        packages.addAll(Arrays.asList(basePackages));
        for (Class<?> typeName : basePackageClasses) {
            packages.add(ClassUtils.getPackageName(typeName));
        }
        return packages;
    }

    @Override
    public Object getQueryLookupStrategyKey() {
        return this.attributes.get(QUERY_LOOKUP_STRATEGY);
    }

    @Override
    public String getNamedQueryLocation() {
        return this.getNullDefaultedAttribute(NAMED_QUERIES_LOCATION);
    }

    @Override
    public String getRepositoryImplementationPostfix() {
        return this.getNullDefaultedAttribute(REPOSITORY_IMPLEMENTATION_POSTFIX);
    }

    @Override
    public Object getSource() {
        return this.configMetadata;
    }

    @Override
    protected Iterable<TypeFilter> getIncludeFilters() {
        return this.parseFilters("includeFilters");
    }

    @Override
    protected Iterable<TypeFilter> getExcludeFilters() {
        return this.parseFilters("excludeFilters");
    }

    private Set<TypeFilter> parseFilters(String attributeName) {
        AnnotationAttributes[] filters;
        HashSet<TypeFilter> result = new HashSet<TypeFilter>();
        for (AnnotationAttributes filter : filters = this.attributes.getAnnotationArray(attributeName)) {
            result.addAll(this.typeFiltersFor(filter));
        }
        return result;
    }

    private String getNullDefaultedAttribute(String attributeName) {
        String attribute = this.attributes.getString(attributeName);
        return StringUtils.hasText(attribute) ? attribute : null;
    }

    @Override
    public String getRepositoryFactoryBeanName() {
        return this.attributes.getClass(REPOSITORY_FACTORY_BEAN_CLASS).getName();
    }

    @Override
    public String getRepositoryBaseClassName() {
        if (!this.attributes.containsKey(REPOSITORY_BASE_CLASS)) {
            return null;
        }
        Class repositoryBaseClass = this.attributes.getClass(REPOSITORY_BASE_CLASS);
        return DefaultRepositoryBaseClass.class.equals(repositoryBaseClass) ? null : repositoryBaseClass.getName();
    }

    public AnnotationAttributes getAttributes() {
        return this.attributes;
    }

    public AnnotationMetadata getEnableAnnotationMetadata() {
        return this.enableAnnotationMetadata;
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)((Object)filterAttributes.getEnum("type"));
        block5: for (Class<?> filterClass : filterAttributes.getClassArray("value")) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, filterClass, "An error occured when processing a @ComponentScan ANNOTATION type filter: ");
                    Class<?> annoClass = filterClass;
                    typeFilters.add(new AnnotationTypeFilter(annoClass));
                    continue block5;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add(new AssignableTypeFilter(filterClass));
                    continue block5;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, filterClass, "An error occured when processing a @ComponentScan CUSTOM type filter: ");
                    typeFilters.add(BeanUtils.instantiateClass(filterClass, TypeFilter.class));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown filter type " + (Object)((Object)filterType));
                }
            }
        }
        for (String expression : this.getPatterns(filterAttributes)) {
            String rawName = filterType.toString();
            if ("REGEX".equals(rawName)) {
                typeFilters.add(new RegexPatternTypeFilter(Pattern.compile(expression)));
                continue;
            }
            if ("ASPECTJ".equals(rawName)) {
                typeFilters.add(new AspectJTypeFilter(expression, this.resourceLoader.getClassLoader()));
                continue;
            }
            throw new IllegalArgumentException("Unknown filter type " + (Object)((Object)filterType));
        }
        return typeFilters;
    }

    @Override
    public boolean shouldConsiderNestedRepositories() {
        return this.attributes.containsKey(CONSIDER_NESTED_REPOSITORIES) && this.attributes.getBoolean(CONSIDER_NESTED_REPOSITORIES);
    }

    @Override
    public String getAttribute(String name) {
        String attribute = this.attributes.getString(name);
        return StringUtils.hasText(attribute) ? attribute : null;
    }

    @Override
    public boolean usesExplicitFilters() {
        return this.hasExplicitFilters;
    }

    private String[] getPatterns(AnnotationAttributes filterAttributes) {
        try {
            return filterAttributes.getStringArray("pattern");
        }
        catch (IllegalArgumentException o_O) {
            return new String[0];
        }
    }
}

