/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PreferredConstructor<T, P extends PersistentProperty<P>> {
    private final Constructor<T> constructor;
    private final List<Parameter<Object, P>> parameters;
    private final Map<PersistentProperty<?>, Boolean> isPropertyParameterCache = new HashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    public PreferredConstructor(Constructor<T> constructor, Parameter<Object, P> ... parameters) {
        Assert.notNull(constructor);
        Assert.notNull(parameters);
        ReflectionUtils.makeAccessible(constructor);
        this.constructor = constructor;
        this.parameters = Arrays.asList(parameters);
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public Iterable<Parameter<Object, P>> getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean isNoArgConstructor() {
        return this.parameters.isEmpty();
    }

    public boolean isExplicitlyAnnotated() {
        return this.constructor.isAnnotationPresent(PersistenceConstructor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConstructorParameter(PersistentProperty<?> property) {
        Assert.notNull(property);
        try {
            this.read.lock();
            Boolean cached = this.isPropertyParameterCache.get(property);
            if (cached != null) {
                boolean bl = cached;
                return bl;
            }
        }
        finally {
            this.read.unlock();
        }
        try {
            this.write.lock();
            for (Parameter<Object, P> parameter : this.parameters) {
                if (!parameter.maps(property)) continue;
                this.isPropertyParameterCache.put(property, true);
                boolean bl = true;
                return bl;
            }
            this.isPropertyParameterCache.put(property, false);
            boolean bl = false;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    public boolean isEnclosingClassParameter(Parameter<?, P> parameter) {
        Assert.notNull(parameter);
        if (this.parameters.isEmpty() || !((Parameter)parameter).isEnclosingClassParameter()) {
            return false;
        }
        return this.parameters.get(0).equals(parameter);
    }

    public static class Parameter<T, P extends PersistentProperty<P>> {
        private final String name;
        private final TypeInformation<T> type;
        private final String key;
        private final PersistentEntity<T, P> entity;
        private Boolean enclosingClassCache;
        private Boolean hasSpelExpression;

        public Parameter(String name, TypeInformation<T> type, Annotation[] annotations, PersistentEntity<T, P> entity) {
            Assert.notNull(type);
            Assert.notNull(annotations);
            this.name = name;
            this.type = type;
            this.key = this.getValue(annotations);
            this.entity = entity;
        }

        private String getValue(Annotation[] annotations) {
            for (Annotation anno : annotations) {
                if (anno.annotationType() != Value.class) continue;
                return ((Value)anno).value();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public TypeInformation<T> getType() {
            return this.type;
        }

        public Class<T> getRawType() {
            return this.type.getType();
        }

        public String getSpelExpression() {
            return this.key;
        }

        public boolean hasSpelExpression() {
            if (this.hasSpelExpression == null) {
                this.hasSpelExpression = StringUtils.hasText(this.getSpelExpression());
            }
            return this.hasSpelExpression;
        }

        boolean maps(PersistentProperty<?> property) {
            Object referencedProperty = this.entity == null ? null : this.entity.getPersistentProperty(this.name);
            return property == null ? false : property.equals(referencedProperty);
        }

        private boolean isEnclosingClassParameter() {
            if (this.enclosingClassCache == null) {
                Class<T> owningType = this.entity.getType();
                this.enclosingClassCache = owningType.isMemberClass() && this.type.getType().equals(owningType.getEnclosingClass());
            }
            return this.enclosingClassCache;
        }

        public boolean equals(Object obj) {
            boolean keyEquals;
            boolean nameEquals;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Parameter)) {
                return false;
            }
            Parameter that = (Parameter)obj;
            boolean bl = this.name == null ? that.name == null : (nameEquals = this.name.equals(that.name));
            boolean bl2 = this.key == null ? that.key == null : (keyEquals = this.key.equals(that.key));
            boolean entityEquals = this.entity == null ? that.entity == null : this.entity.equals(that.entity);
            return nameEquals && keyEquals && entityEquals && this.type.equals(that.type);
        }

        public int hashCode() {
            int result = 17;
            result += 31 * ObjectUtils.nullSafeHashCode(this.name);
            result += 31 * ObjectUtils.nullSafeHashCode(this.key);
            result += 31 * ObjectUtils.nullSafeHashCode(this.entity);
            return result += 31 * this.type.hashCode();
        }
    }
}

